"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareMenuRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ShareMenuRegistry {
  constructor({
    newVersionEnabled
  }) {
    (0, _defineProperty2.default)(this, "shareMenuProviders", new Map());
    (0, _defineProperty2.default)(this, "newVersionEnabled", void 0);
    this.newVersionEnabled = newVersionEnabled;
  }
  setup() {
    return {
      /**
       * Register an additional source of items for share context menu items. All registered providers
       * will be called if a consumer displays the context menu. Returned `ShareMenuItem`s will be shown
       * in the context menu together with the default built-in share options.
       * Each share provider needs a globally unique id.
       * @param shareMenuProvider
       */
      register: shareMenuProvider => {
        if (!this.newVersionEnabled && (shareMenuProvider.id === 'csvReports' || shareMenuProvider.id === 'screenCaptureReports' || shareMenuProvider.id === 'csvDownloadLens')) {
          if (this.shareMenuProviders.has(shareMenuProvider.id)) {
            throw new Error(`Share menu provider with id [${shareMenuProvider.id}] has already been registered. Use a unique id.`);
          }
          this.shareMenuProviders.set(shareMenuProvider.id, shareMenuProvider);
        } else if (shareMenuProvider.id === 'csvReportsModal' || shareMenuProvider.id === 'modalImageReports' || shareMenuProvider.id === 'csvDownloadLens') {
          this.shareMenuProviders.set(shareMenuProvider.id, shareMenuProvider);
        }
      }
    };
  }
  start() {
    return {
      getShareMenuItems: context => Array.from(this.shareMenuProviders.values()).flatMap(shareActionProvider => shareActionProvider.getShareMenuItems(context))
    };
  }
}
exports.ShareMenuRegistry = ShareMenuRegistry;