"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ExportContentUi = ({
  isDirty,
  objectType,
  aggregateReportTypes,
  intl
}) => {
  var _ref;
  // needed for CSV in Discover
  const firstRadio = (_ref = aggregateReportTypes[0].reportType) !== null && _ref !== void 0 ? _ref : 'printablePdfV2';
  const [, setIsStale] = (0, _react.useState)(false);
  const [isCreatingReport, setIsCreatingReport] = (0, _react.useState)(false);
  const [selectedRadio, setSelectedRadio] = (0, _react.useState)(firstRadio);
  const [usePrintLayout, setPrintLayout] = (0, _react.useState)(false);
  const isMounted = (0, _useMountedState.default)();
  const markAsStale = (0, _react.useCallback)(() => {
    if (!isMounted) return;
    setIsStale(true);
  }, [isMounted]);
  const getProperties = (0, _react.useCallback)(() => {
    if (objectType === 'search') {
      return aggregateReportTypes[0];
    } else {
      return aggregateReportTypes === null || aggregateReportTypes === void 0 ? void 0 : aggregateReportTypes.filter(({
        reportType
      }) => reportType === selectedRadio)[0];
    }
  }, [selectedRadio, aggregateReportTypes, objectType]);
  const handlePrintLayoutChange = (0, _react.useCallback)(evt => {
    setPrintLayout(evt.target.checked);
    getProperties();
  }, [setPrintLayout, getProperties]);
  const {
    generateReportButton,
    helpText,
    renderCopyURLButton,
    generateReport,
    generateReportForPrinting,
    downloadCSVLens,
    absoluteUrl,
    renderLayoutOptionSwitch
  } = getProperties();
  const getRadioOptions = (0, _react.useCallback)(() => {
    if (!aggregateReportTypes.length) {
      throw new Error('No content registered for this tab');
    }
    return aggregateReportTypes.map(({
      reportType,
      label
    }) => {
      if (reportType == null) {
        throw new Error('expected reportType to be string!');
      }
      return {
        id: reportType,
        label,
        'data-test-subj': `${reportType}-radioOption`
      };
    });
  }, [aggregateReportTypes]);
  const renderLayoutOptionsSwitch = (0, _react.useCallback)(() => {
    if (renderLayoutOptionSwitch) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          css: {
            textWrap: 'nowrap'
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "share.screenCapturePanelContent.optimizeForPrintingLabel",
          defaultMessage: "For printing"
        })),
        checked: usePrintLayout,
        onChange: handlePrintLayoutChange,
        "data-test-subj": "usePrintLayout"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "share.screenCapturePanelContent.optimizeForPrintingHelpText",
          defaultMessage: "Uses multiple pages, showing at most 2 visualizations per page "
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "questionInCircle"
      }))));
    }
  }, [usePrintLayout, renderLayoutOptionSwitch, handlePrintLayoutChange]);
  (0, _react.useEffect)(() => {
    isMounted();
    getRadioOptions();
    renderLayoutOptionsSwitch();
    getProperties();
    markAsStale();
  }, [aggregateReportTypes, getProperties, getRadioOptions, renderLayoutOptionsSwitch, markAsStale, isMounted]);
  const showCopyURLButton = (0, _react.useCallback)(() => {
    if (renderCopyURLButton) return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: isDirty ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.modalContent.unsavedStateErrorText",
        defaultMessage: "Save your work before copying this URL."
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.modalContent.savedStateErrorText",
        defaultMessage: "Copy this POST URL to call generation from outside Kibana or from Watcher."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: absoluteUrl !== null && absoluteUrl !== void 0 ? absoluteUrl : ''
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "copy",
      flush: "both",
      onClick: copy,
      "data-test-subj": "shareReportingCopyURL"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      id: "share.savePostURLMessage",
      content: "Unsaved changes. This URL will not reflect later saved changes unless you save."
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.modalContent.copyUrlButtonLabel",
      defaultMessage: "Post URL"
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.postURLWatcherMessage",
        defaultMessage: "Copy this POST URL to call generation from outside Kibana or from Watcher. Unsaved changes: URL may change if you upgrade Kibana"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle"
    }))));
  }, [absoluteUrl, isDirty, renderCopyURLButton]);
  const getReport = (0, _react.useCallback)(() => {
    if (!generateReportForPrinting && !generateReport && !downloadCSVLens) {
      throw new Error('Report cannot be run due to no generate report method registered');
    }
    if (objectType === 'lens' && selectedRadio === 'lens_csv') {
      return downloadCSVLens();
    }
    return usePrintLayout ? generateReportForPrinting({
      intl
    }) : generateReport({
      intl
    });
  }, [downloadCSVLens, generateReport, generateReportForPrinting, objectType, selectedRadio, usePrintLayout, intl]);
  const renderGenerateReportButton = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      color: "primary",
      onClick: () => {
        setIsCreatingReport(true);
        getReport();
        setIsCreatingReport(false);
      },
      "data-test-subj": "generateReportButton",
      isLoading: Boolean(isCreatingReport)
    }, generateReportButton);
  }, [generateReportButton, getReport, isCreatingReport]);
  const renderRadioOptions = () => {
    if (getRadioOptions().length > 1) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        justifyContent: 'spaceBetween'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
        options: getRadioOptions(),
        onChange: id => {
          setSelectedRadio(id);
          getProperties();
        },
        name: "image reporting radio group",
        idSelected: selectedRadio,
        legend: {
          children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "share.fileType",
            defaultMessage: "File type"
          })
        }
      }));
    }
  };
  const getHelpText = () => {
    if (objectType === 'lens' && generateReport !== undefined) {
      return helpText;
    } else {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.helpText.goldLicense.roleNotPDFPNG",
        defaultMessage: "Export a CSV of this visualization."
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), getHelpText(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), renderRadioOptions(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false
  }, renderLayoutOptionsSwitch(), showCopyURLButton(), renderGenerateReportButton()));
};
const ExportContent = exports.ExportContent = (0, _i18nReact.injectI18n)(ExportContentUi);