"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareMenuV2 = exports.ShareMenuTabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxTabbedModal = require("@kbn/shared-ux-tabbed-modal");
var _context = require("./context");
var _tabs = require("./tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ShareMenuV2 = ({
  shareContext
}) => {
  return /*#__PURE__*/_react.default.createElement(_context.ShareTabsContext.Provider, {
    value: shareContext
  }, /*#__PURE__*/_react.default.createElement(ShareMenuTabs, null));
};

// this file is intended to replace share_context_menu
exports.ShareMenuV2 = ShareMenuV2;
const ShareMenuTabs = () => {
  const shareContext = (0, _context.useShareTabsContext)();
  if (!shareContext) {
    return null;
  }
  const {
    allowEmbed,
    objectType,
    onClose,
    shareMenuItems
  } = shareContext;
  const tabs = [];
  tabs.push(_tabs.linkTab);
  if (shareMenuItems.length > 0) {
    tabs.push(_tabs.exportTab);
  }
  if (allowEmbed) {
    tabs.push(_tabs.embedTab);
  }
  const formattedTitle = objectType === 'lens' ? `Share this Lens visualization` : `Share this ${objectType}`;
  return /*#__PURE__*/_react.default.createElement(_sharedUxTabbedModal.TabbedModal, {
    tabs: tabs,
    modalWidth: 498,
    onClose: onClose,
    modalTitle: formattedTitle,
    defaultSelectedTabId: "link"
  });
};
exports.ShareMenuTabs = ShareMenuTabs;