"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  config: true
};
exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = _configSchema.schema.object({
  // Is this plugin enabled?
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  // Config namespace for developer-specific settings.
  developer: _configSchema.schema.maybe(_configSchema.schema.object({
    // Settings for the project switcher.
    projectSwitcher: _configSchema.schema.maybe(_configSchema.schema.object({
      // Should the switcher be enabled?
      enabled: _configSchema.schema.conditional(_configSchema.schema.contextRef('dev'), false, _configSchema.schema.boolean({
        validate: rawValue => {
          if (rawValue === true) {
            return 'Switcher can only be enabled in development mode';
          }
        },
        defaultValue: false
      }), _configSchema.schema.boolean({
        defaultValue: true
      })),
      // Which project is currently selected?
      currentType: _configSchema.schema.oneOf([_configSchema.schema.literal('security'), _configSchema.schema.literal('observability'), _configSchema.schema.literal('search')])
    }))
  }))
});
const config = exports.config = {
  schema: configSchema,
  exposeToBrowser: {
    developer: true
  }
};