"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMappingRoutes = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerMappingRoutes = ({
  router
}) => {
  router.get({
    path: '/internal/serverless_search/mappings/{index_name}',
    validate: {
      params: _configSchema.schema.object({
        index_name: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    const mapping = await client.asCurrentUser.indices.getMapping({
      expand_wildcards: ['open'],
      index: request.params.index_name
    });
    return response.ok({
      body: mapping[request.params.index_name],
      headers: {
        'content-type': 'application/json'
      }
    });
  });
};
exports.registerMappingRoutes = registerMappingRoutes;