"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navigationTree = void 0;
var _i18n = require("@kbn/i18n");
var _i18n_string = require("../common/i18n_string");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const navigationTree = exports.navigationTree = {
  body: [{
    type: 'navGroup',
    id: 'search_project_nav',
    title: 'Elasticsearch',
    icon: 'logoElasticsearch',
    defaultIsCollapsed: false,
    isCollapsible: false,
    breadcrumbStatus: 'hidden',
    children: [{
      id: 'home',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.home', {
        defaultMessage: 'Home'
      }),
      link: 'serverlessElasticsearch',
      spaceBefore: 'm'
    }, {
      id: 'dev_tools',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.devTools', {
        defaultMessage: 'Dev Tools'
      }),
      link: 'dev_tools:console',
      getIsActive: ({
        pathNameSerialized,
        prepend
      }) => {
        return pathNameSerialized.startsWith(prepend('/app/dev_tools'));
      }
    }, {
      id: 'kibana',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.kibana', {
        defaultMessage: 'Kibana'
      }),
      spaceBefore: 'm',
      children: [{
        link: 'discover'
      }, {
        link: 'dashboards',
        getIsActive: ({
          pathNameSerialized,
          prepend
        }) => {
          return pathNameSerialized.startsWith(prepend('/app/dashboards'));
        }
      }]
    }, {
      id: 'content',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.content', {
        defaultMessage: 'Content'
      }),
      spaceBefore: 'm',
      children: [{
        title: _i18n.i18n.translate('xpack.serverlessSearch.nav.content.indices', {
          defaultMessage: 'Index Management'
        }),
        link: 'management:index_management',
        breadcrumbStatus: 'hidden' /* management sub-pages set their breadcrumbs themselves */
      }, {
        title: _i18n_string.CONNECTORS_LABEL,
        link: 'serverlessConnectors'
      }]
    }, {
      id: 'build',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.build', {
        defaultMessage: 'Build'
      }),
      spaceBefore: 'm',
      children: [{
        id: 'searchPlayground',
        title: _i18n.i18n.translate('xpack.serverlessSearch.nav.build.searchPlayground', {
          defaultMessage: 'Playground'
        }),
        link: 'searchPlayground'
      }]
    }]
  }],
  footer: [{
    type: 'navGroup',
    id: 'project_settings_project_nav',
    title: _i18n.i18n.translate('xpack.serverlessSearch.nav.projectSettings', {
      defaultMessage: 'Project settings'
    }),
    icon: 'gear',
    breadcrumbStatus: 'hidden',
    children: [{
      link: 'management',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.mngt', {
        defaultMessage: 'Management'
      })
    }, {
      id: 'cloudLinkDeployment',
      cloudLink: 'deployment',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.performance', {
        defaultMessage: 'Performance'
      })
    }, {
      id: 'cloudLinkUserAndRoles',
      cloudLink: 'userAndRoles'
    }, {
      id: 'cloudLinkBilling',
      cloudLink: 'billingAndSub'
    }]
  }]
};