"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileUploadCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../hooks/use_kibana");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileUploadCallout = () => {
  const {
    application: {
      navigateToUrl
    },
    http
  } = (0, _use_kibana.useKibanaServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.selectClient.fileUploadCallout.title', {
      defaultMessage: 'Upload your data from a file'
    }),
    size: "s",
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.selectClient.fileUploadCallout.description",
    defaultMessage: "Upload your file, analyze its data, and import the data into an Elasticsearch index."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "exportAction",
    "data-test-subj": "fileupload-callout-cta",
    onClick: () => navigateToUrl(http.basePath.prepend(_constants.FILE_UPLOAD_PATH))
  }, _i18n.i18n.translate('xpack.serverlessSearch.selectClient.fileUploadCallout.cta', {
    defaultMessage: 'Upload a file'
  })))));
};
exports.FileUploadCallout = FileUploadCallout;