"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDescription = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _i18n_string = require("../../../../common/i18n_string");
var _use_kibana = require("../../hooks/use_kibana");
var _use_connector = require("../../hooks/api/use_connector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditDescription = ({
  connector
}) => {
  const [isEditing, setIsEditing] = (0, _react2.useState)(false);
  const [newDescription, setNewDescription] = (0, _react2.useState)(connector.description || '');
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  (0, _react2.useEffect)(() => setNewDescription(connector.description || ''), [connector.description]);
  const {
    isLoading,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async inputDescription => {
      const body = {
        description: inputDescription
      };
      await http.post(`/internal/serverless_search/connectors/${connector.id}/description`, {
        body: JSON.stringify(body)
      });
      return inputDescription;
    },
    onSuccess: successData => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          description: successData
        }
      });
      queryClient.invalidateQueries(queryKey);
      setIsEditing(false);
    }
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.serverlessSearch.connectors.descriptionHelpText', {
      defaultMessage: 'Optional description for your connector.'
    }),
    label: _i18n.i18n.translate('xpack.serverlessSearch.connectors.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "serverlessSearchEditDescriptionButton",
      size: "xs",
      onClick: () => setIsEditing(true)
    }, _i18n_string.EDIT_LABEL)
  }, isEditing ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "serverlessSearchEditDescriptionFieldText",
    onChange: event => setNewDescription(event.target.value),
    value: newDescription || ''
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "serverlessSearchConnectorDescription"
  }, connector.description))), isEditing && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
                  justify-content: center;
                `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchSaveDescriptionButton",
    color: "primary",
    fill: true,
    onClick: () => mutate(newDescription),
    type: "submit",
    size: "s",
    isLoading: isLoading
  }, _i18n_string.SAVE_LABEL)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
                  justify-content: center;
                `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchCancelDescriptionButton",
    size: "s",
    isLoading: isLoading,
    onClick: () => {
      setNewDescription(connector.description || '');
      setIsEditing(false);
    }
  }, _i18n_string.CANCEL_LABEL))))));
};
exports.EditDescription = EditDescription;