"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditConnector = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18n_string = require("../../../../common/i18n_string");
var _use_kibana = require("../../hooks/use_kibana");
var _edit_name = require("./edit_name");
var _edit_service_type = require("./edit_service_type");
var _edit_description = require("./edit_description");
var _delete_connector_modal = require("./delete_connector_modal");
var _connector_configuration = require("./connector_config/connector_configuration");
var _use_connector = require("../../hooks/api/use_connector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditConnector = () => {
  const [deleteModalIsOpen, setDeleteModalIsOpen] = (0, _react.useState)(false);
  const [menuIsOpen, setMenuIsOpen] = (0, _react.useState)(false);
  const {
    id
  } = (0, _reactRouterDom.useParams)();
  (0, _react.useEffect)(() => setDeleteModalIsOpen(false), [id, setDeleteModalIsOpen]);
  const {
    application: {
      navigateToUrl
    }
  } = (0, _use_kibana.useKibanaServices)();
  const {
    data,
    isLoading
  } = (0, _use_connector.useConnector)(id);
  if (isLoading) {
    /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
      offset: 0,
      grow: true,
      restrictWidth: true,
      "data-test-subj": "svlSearchEditConnectorsPage"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.loading', {
        defaultMessage: 'Loading'
      }))
    }));
  }
  if (!(data !== null && data !== void 0 && data.connector)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
      offset: 0,
      grow: true,
      restrictWidth: true,
      "data-test-subj": "svlSearchEditConnectorsPage"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.notFound', {
        defaultMessage: 'Could not find connector {id}',
        values: {
          id
        }
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "serverlessSearchEditConnectorGoBackButton",
        color: "primary",
        fill: true,
        onClick: () => navigateToUrl(`./`)
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.goBack', {
        defaultMessage: 'Go back'
      }))
    }));
  }
  const {
    connector
  } = data;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    grow: true,
    restrictWidth: true,
    "data-test-subj": "svlSearchEditConnectorsPage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    grow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n_string.CONNECTOR_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_edit_name.EditName, {
    connector: connector
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, deleteModalIsOpen && /*#__PURE__*/_react.default.createElement(_delete_connector_modal.DeleteConnectorModal, {
    closeDeleteModal: () => setDeleteModalIsOpen(false),
    connectorId: connector.id,
    connectorName: connector.name || _i18n_string.CONNECTOR_LABEL,
    onSuccess: () => navigateToUrl('./')
  }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: 'connectorMenu',
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "serverlessSearchEditConnectorButton",
      "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.connectors.openMenuLabel', {
        defaultMessage: 'Open menu'
      }),
      iconType: "boxesVertical",
      onClick: () => setMenuIsOpen(!menuIsOpen)
    }),
    isOpen: menuIsOpen,
    closePopover: () => setMenuIsOpen(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      items: [{
        name: _i18n_string.COPY_CONNECTOR_ID_LABEL,
        icon: 'copy',
        onClick: () => {
          (0, _eui.copyToClipboard)(connector.id);
          setMenuIsOpen(false);
        }
      }, {
        name: _i18n_string.DELETE_CONNECTOR_LABEL,
        icon: 'trash',
        onClick: () => {
          setDeleteModalIsOpen(true);
        }
      }]
    }]
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_edit_service_type.EditServiceType, {
    connector: connector
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_edit_description.EditDescription, {
    connector: connector
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_connector_configuration.ConnectorConfiguration, {
    connector: connector
  }))))));
};
exports.EditConnector = EditConnector;