"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConnectorModal = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteConnectorModal = ({
  connectorId,
  connectorName,
  closeDeleteModal,
  onSuccess
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const {
    isLoading,
    isSuccess,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async () => {
      const result = await http.delete(`/internal/serverless_search/connectors/${connectorId}`);
      return result.acknowledged;
    }
  });
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      if (onSuccess) {
        onSuccess();
      }
      closeDeleteModal();
    }
  }, [closeDeleteModal, isSuccess, onSuccess]);
  const [inputConnectorName, setInputConnectorName] = (0, _react.useState)('');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.deleteModal.title', {
      defaultMessage: 'Are you sure you want to delete connector {connectorName}',
      values: {
        connectorName
      }
    }),
    onCancel: () => {
      closeDeleteModal();
    },
    onConfirm: () => {
      mutate();
    },
    cancelButtonText: isLoading ? _i18n.i18n.translate('xpack.serverlessSearch.connectors.deleteModal.closeButton.title', {
      defaultMessage: 'Close'
    }) : _i18n.i18n.translate('xpack.serverlessSearch.connectors.deleteModal.cancelButton.title', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.serverlessSearch.connectors.deleteModal.confirmButton.title', {
      defaultMessage: 'Delete index'
    }),
    defaultFocusedButton: "confirm",
    buttonColor: "danger",
    confirmButtonDisabled: inputConnectorName.trim() !== connectorName,
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.deleteModal.syncsWarning.connectorNameDescription', {
    defaultMessage: 'This action cannot be undone. Please type {connectorName} to confirm.',
    values: {
      connectorName
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.serverlessSearch.connectors.deleteModal.connectorNameInput.label', {
      defaultMessage: 'Connector name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "serverlessSearchDeleteConnectorModalFieldText",
    onChange: e => setInputConnectorName(e.target.value),
    value: inputConnectorName
  }))));
};
exports.DeleteConnectorModal = DeleteConnectorModal;