"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THRESHOLD_RULE_TYPE_ID = exports.SIGNALS_ID = exports.SAVED_QUERY_RULE_TYPE_ID = exports.QUERY_RULE_TYPE_ID = exports.NEW_TERMS_RULE_TYPE_ID = exports.ML_RULE_TYPE_ID = exports.INDICATOR_RULE_TYPE_ID = exports.ESQL_RULE_TYPE_ID = exports.EQL_RULE_TYPE_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Id for the legacy siem signals alerting type
 */
const SIGNALS_ID = exports.SIGNALS_ID = `siem.signals`;

/**
 * IDs for alerts-as-data rule types
 */
const RULE_TYPE_PREFIX = `siem`;
const EQL_RULE_TYPE_ID = exports.EQL_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.eqlRule`;
const ESQL_RULE_TYPE_ID = exports.ESQL_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.esqlRule`;
const INDICATOR_RULE_TYPE_ID = exports.INDICATOR_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.indicatorRule`;
const ML_RULE_TYPE_ID = exports.ML_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.mlRule`;
const QUERY_RULE_TYPE_ID = exports.QUERY_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.queryRule`;
const SAVED_QUERY_RULE_TYPE_ID = exports.SAVED_QUERY_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.savedQueryRule`;
const THRESHOLD_RULE_TYPE_ID = exports.THRESHOLD_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.thresholdRule`;
const NEW_TERMS_RULE_TYPE_ID = exports.NEW_TERMS_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.newTermsRule`;