"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patchListItem = exports.findListItems = exports.deleteListItem = exports.createListItem = void 0;
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _TaskEither = require("fp-ts/lib/TaskEither");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _fp_utils = require("../fp_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const version = '2023-10-31';

/**
 * Fetch list items
 */
const findListItems = async ({
  http,
  cursor,
  page,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  list_id,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  per_page,
  signal,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  sort_field,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  sort_order,
  filter
}) => {
  return http.fetch(`${_securitysolutionListConstants.LIST_ITEM_URL}/_find`, {
    method: 'GET',
    query: {
      cursor,
      page,
      per_page,
      sort_field,
      sort_order,
      list_id,
      filter
    },
    signal,
    version
  });
};
const findListItemsWithValidation = async ({
  cursor,
  http,
  pageIndex,
  pageSize,
  signal,
  sortField,
  sortOrder,
  filter,
  listId
}) => (0, _pipeable.pipe)({
  cursor: cursor != null ? cursor.toString() : undefined,
  page: pageIndex != null ? pageIndex.toString() : undefined,
  per_page: pageSize != null ? pageSize.toString() : undefined,
  sort_field: sortField != null ? sortField.toString() : undefined,
  filter: filter != null ? filter.toString() : undefined,
  sort_order: sortOrder,
  list_id: listId
}, payload => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.findListItemSchema, payload)), (0, _TaskEither.chain)(payload => (0, _TaskEither.tryCatch)(() => findListItems({
  http,
  signal,
  ...payload
}), _fp_utils.toError)), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.foundListItemSchema, response))), (0, _function.flow)(_fp_utils.toPromise));
exports.findListItems = findListItemsWithValidation;
const deleteListItem = async ({
  http,
  id,
  signal,
  refresh
}) => http.fetch(_securitysolutionListConstants.LIST_ITEM_URL, {
  method: 'DELETE',
  query: {
    id,
    refresh
  },
  signal,
  version
});
const deleteListItemWithValidation = async ({
  http,
  id,
  signal,
  refresh
}) => (0, _pipeable.pipe)({
  id,
  refresh
}, payload => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.deleteListItemSchema, payload)), (0, _TaskEither.chain)(payload => (0, _TaskEither.tryCatch)(() => deleteListItem({
  http,
  signal,
  ...payload,
  value: undefined,
  list_id: undefined
}), _fp_utils.toError)), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.listItemSchema, response))), (0, _function.flow)(_fp_utils.toPromise));
exports.deleteListItem = deleteListItemWithValidation;
const patchListItem = async ({
  http,
  id,
  signal,
  value,
  _version
}) => http.fetch(_securitysolutionListConstants.LIST_ITEM_URL, {
  method: 'PATCH',
  body: JSON.stringify({
    id,
    value,
    _version
  }),
  signal,
  version
});
const patchListItemWithValidation = async ({
  http,
  id,
  signal,
  value,
  refresh,
  _version
}) => (0, _pipeable.pipe)({
  id,
  value,
  _version,
  refresh
}, payload => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.patchListItemSchema, payload)), (0, _TaskEither.chain)(payload => (0, _TaskEither.tryCatch)(() => patchListItem({
  http,
  signal,
  ...payload
}), _fp_utils.toError)), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.listItemSchema, response))), (0, _function.flow)(_fp_utils.toPromise));
exports.patchListItem = patchListItemWithValidation;
const createListItem = async ({
  http,
  signal,
  value,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  list_id,
  refresh
}) => http.fetch(_securitysolutionListConstants.LIST_ITEM_URL, {
  method: 'POST',
  body: JSON.stringify({
    value,
    list_id,
    refresh
  }),
  signal,
  version
});
const createListItemWithValidation = async ({
  http,
  signal,
  value,
  refresh,
  listId
}) => (0, _pipeable.pipe)({
  list_id: listId,
  value,
  refresh
}, payload => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.createListItemSchema, payload)), (0, _TaskEither.chain)(payload => (0, _TaskEither.tryCatch)(() => createListItem({
  http,
  signal,
  ...payload
}), _fp_utils.toError)), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.listItemSchema, response))), (0, _function.flow)(_fp_utils.toPromise));
exports.createListItem = createListItemWithValidation;