"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IsoDateString = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Types the IsoDateString as:
 *   - A string that is an ISOString
 */

const IsoDateString = exports.IsoDateString = new t.Type('IsoDateString', t.string.is, (input, context) => {
  if (typeof input === 'string') {
    try {
      const parsed = new Date(input);
      if (parsed.toISOString() === input) {
        return t.success(input);
      } else {
        return t.failure(input, context);
      }
    } catch (err) {
      return t.failure(input, context);
    }
  } else {
    return t.failure(input, context);
  }
}, t.identity);