"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.importExceptionsListSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _exception_list = require("../../common/exception_list");
var _os_type = require("../../common/os_type");
var _name = require("../../common/name");
var _description = require("../../common/description");
var _namespace_type = require("../../common/namespace_type");
var _tags = require("../../common/tags");
var _meta = require("../../common/meta");
var _list_id = require("../../common/list_id");
var _id = require("../../common/id");
var _created_at = require("../../common/created_at");
var _created_by = require("../../common/created_by");
var _updated_at = require("../../common/updated_at");
var _updated_by = require("../../common/updated_by");
var _underscore_version = require("../../common/underscore_version");
var _tie_breaker_id = require("../../common/tie_breaker_id");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Differences from this and the createExceptionsSchema are
 *   - list_id is required
 *   - id is optional (but ignored in the import code - list_id is exclusively used for imports)
 *   - immutable is optional but if it is any value other than false it will be rejected
 *   - created_at is optional (but ignored in the import code)
 *   - updated_at is optional (but ignored in the import code)
 *   - created_by is optional (but ignored in the import code)
 *   - updated_by is optional (but ignored in the import code)
 */
const importExceptionsListSchema = exports.importExceptionsListSchema = t.intersection([t.exact(t.type({
  description: _description.description,
  name: _name.name,
  type: _exception_list.exceptionListType,
  list_id: _list_id.list_id
})), t.exact(t.partial({
  id: _id.id,
  // defaults to undefined if not set during decode
  immutable: _securitysolutionIoTsTypes.OnlyFalseAllowed,
  meta: _meta.meta,
  // defaults to undefined if not set during decode
  namespace_type: _namespace_type.namespace_type,
  // defaults to 'single' if not set during decode
  os_types: _os_type.osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: _tags.tags,
  // defaults to empty array if not set during decode
  created_at: _created_at.created_at,
  // defaults "undefined" if not set during decode
  updated_at: _updated_at.updated_at,
  // defaults "undefined" if not set during decode
  created_by: _created_by.created_by,
  // defaults "undefined" if not set during decode
  updated_by: _updated_by.updated_by,
  // defaults "undefined" if not set during decode
  _version: _underscore_version._version,
  // defaults to undefined if not set during decode
  tie_breaker_id: _tie_breaker_id.tie_breaker_id,
  version: _securitysolutionIoTsTypes.DefaultVersionNumber // defaults to numerical 1 if not set during decode
}))]);

// This type is used after a decode since some things are defaults after a decode.