"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionServerlessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverlessSecuritySettings = require("@kbn/serverless-security-settings");
var _pli_features = require("../common/pli/pli_features");
var _config = require("./config");
var _usage_reporting_task = require("./task_manager/usage_reporting_task");
var _cloud_security_metering_task_config = require("./cloud_security/cloud_security_metering_task_config");
var _product_features = require("./product_features");
var _metering = require("./endpoint/constants/metering");
var _services = require("./endpoint/services");
var _enable_rule_actions = require("./rules/enable_rule_actions");
var _nlp_cleanup_task = require("./task_manager/nlp_cleanup_task/nlp_cleanup_task");
var _event_based_telemetry = require("./telemetry/event_based_telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecuritySolutionServerlessPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "cloudSecurityUsageReportingTask", void 0);
    (0, _defineProperty2.default)(this, "endpointUsageReportingTask", void 0);
    (0, _defineProperty2.default)(this, "nlpCleanupTask", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.logger = this.initializerContext.logger.get();
  }
  setup(coreSetup, pluginsSetup) {
    this.config = (0, _config.createConfig)(this.initializerContext, pluginsSetup.securitySolution);
    const enabledProductFeatures = (0, _pli_features.getProductProductFeatures)(this.config.productTypes);

    // securitySolutionEss plugin should always be disabled when securitySolutionServerless is enabled.
    // This check is an additional layer of security to prevent double registrations when
    // `plugins.forceEnableAllPlugins` flag is enabled. Should never happen in real scenarios.
    const shouldRegister = pluginsSetup.securitySolutionEss == null;
    if (shouldRegister) {
      const productTypesStr = JSON.stringify(this.config.productTypes, null, 2);
      this.logger.info(`Security Solution running with product types:\n${productTypesStr}`);
      const productFeaturesConfigurator = (0, _product_features.getProductProductFeaturesConfigurator)(enabledProductFeatures, this.config);
      pluginsSetup.securitySolution.setProductFeaturesConfigurator(productFeaturesConfigurator);
    }

    // Register telemetry events
    _event_based_telemetry.telemetryEvents.forEach(eventConfig => coreSetup.analytics.registerEventType(eventConfig));
    (0, _enable_rule_actions.enableRuleActions)({
      actions: pluginsSetup.actions,
      productFeatureKeys: enabledProductFeatures
    });
    this.cloudSecurityUsageReportingTask = new _usage_reporting_task.SecurityUsageReportingTask({
      core: coreSetup,
      logFactory: this.initializerContext.logger,
      config: this.config,
      taskManager: pluginsSetup.taskManager,
      cloudSetup: pluginsSetup.cloud,
      taskType: _cloud_security_metering_task_config.cloudSecurityMetringTaskProperties.taskType,
      taskTitle: _cloud_security_metering_task_config.cloudSecurityMetringTaskProperties.taskTitle,
      version: _cloud_security_metering_task_config.cloudSecurityMetringTaskProperties.version,
      meteringCallback: _cloud_security_metering_task_config.cloudSecurityMetringTaskProperties.meteringCallback
    });
    this.endpointUsageReportingTask = new _usage_reporting_task.SecurityUsageReportingTask({
      core: coreSetup,
      logFactory: this.initializerContext.logger,
      config: this.config,
      taskType: _metering.METERING_TASK.TYPE,
      taskTitle: _metering.METERING_TASK.TITLE,
      version: _metering.METERING_TASK.VERSION,
      meteringCallback: _services.endpointMeteringService.getUsageRecords,
      taskManager: pluginsSetup.taskManager,
      cloudSetup: pluginsSetup.cloud
    });
    this.nlpCleanupTask = new _nlp_cleanup_task.NLPCleanupTask({
      core: coreSetup,
      logFactory: this.initializerContext.logger,
      productTier: (0, _product_features.getSecurityProductTier)(this.config, this.logger),
      taskManager: pluginsSetup.taskManager
    });
    pluginsSetup.serverless.setupProjectSettings(_serverlessSecuritySettings.SECURITY_PROJECT_SETTINGS);
    return {};
  }
  start(coreStart, pluginsSetup) {
    var _this$cloudSecurityUs, _this$endpointUsageRe, _this$nlpCleanupTask;
    const internalESClient = coreStart.elasticsearch.client.asInternalUser;
    const internalSOClient = coreStart.savedObjects.createInternalRepository();
    (_this$cloudSecurityUs = this.cloudSecurityUsageReportingTask) === null || _this$cloudSecurityUs === void 0 ? void 0 : _this$cloudSecurityUs.start({
      taskManager: pluginsSetup.taskManager,
      interval: _cloud_security_metering_task_config.cloudSecurityMetringTaskProperties.interval
    });
    (_this$endpointUsageRe = this.endpointUsageReportingTask) === null || _this$endpointUsageRe === void 0 ? void 0 : _this$endpointUsageRe.start({
      taskManager: pluginsSetup.taskManager,
      interval: _metering.METERING_TASK.INTERVAL
    });
    (_this$nlpCleanupTask = this.nlpCleanupTask) === null || _this$nlpCleanupTask === void 0 ? void 0 : _this$nlpCleanupTask.start({
      taskManager: pluginsSetup.taskManager
    });
    (0, _services.setEndpointPackagePolicyServerlessFlag)(internalSOClient, internalESClient, pluginsSetup.fleet.packagePolicyService);
    return {};
  }
  stop() {}
}
exports.SecuritySolutionServerlessPlugin = SecuritySolutionServerlessPlugin;