"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCloudProductTier = exports.cloudSecurityMetringCallback = void 0;
var _product = require("../../common/product");
var _cloud_security_metering_task = require("./cloud_security_metering_task");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cloudSecurityMetringCallback = async ({
  esClient,
  cloudSetup,
  logger,
  taskId,
  lastSuccessfulReport,
  config
}) => {
  var _cloudSetup$serverles;
  const projectId = (cloudSetup === null || cloudSetup === void 0 ? void 0 : (_cloudSetup$serverles = cloudSetup.serverless) === null || _cloudSetup$serverles === void 0 ? void 0 : _cloudSetup$serverles.projectId) || 'missing_project_id';
  const tier = getCloudProductTier(config, logger);
  try {
    const cloudSecuritySolutions = [_constants.CSPM, _constants.KSPM, _constants.CNVM, _constants.CLOUD_DEFEND];
    const promiseResults = await Promise.allSettled(cloudSecuritySolutions.map(cloudSecuritySolution => (0, _cloud_security_metering_task.getCloudSecurityUsageRecord)({
      esClient,
      projectId,
      logger,
      taskId,
      lastSuccessfulReport,
      cloudSecuritySolution,
      tier
    })));
    const cloudSecurityUsageRecords = [];
    promiseResults.forEach(result => {
      if (result.status === 'fulfilled') {
        if (result.value !== undefined && result.value.length > 0) {
          cloudSecurityUsageRecords.push(...result.value);
        }
      } else {
        // Handle or log the rejection reason
        logger.error(`Promise rejected with reason: ${result.reason}`);
      }
    });
    return {
      records: cloudSecurityUsageRecords
    };
  } catch (err) {
    logger.error(`Failed to process Cloud Security metering data ${err}`);
    return {
      records: []
    };
  }
};
exports.cloudSecurityMetringCallback = cloudSecurityMetringCallback;
const getCloudProductTier = (config, logger) => {
  const cloud = config.productTypes.find(productType => productType.product_line === _product.ProductLine.cloud);
  const tier = cloud ? cloud.product_tier : 'none';
  if (tier === 'none') {
    logger.error(`Failed to fetch cloud product tier, config: ${JSON.stringify(config)}`);
  }
  return tier;
};
exports.getCloudProductTier = getCloudProductTier;