"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsellingSections = exports.upsellingPages = exports.upsellingMessages = exports.registerUpsellings = void 0;
var _common = require("@kbn/security-solution-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _messages = require("@kbn/security-solution-upselling/messages");
var _keys = require("@kbn/security-solution-features/keys");
var _endpoint_management = require("./sections/endpoint_management");
var _pli_features = require("../../common/pli/pli_features");
var _lazy_upselling = require("./lazy_upselling");
var _use_product_type_by_pli = require("./hooks/use_product_type_by_pli");
var _services = require("../common/services");
var _getProductTypeByPLI2;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const registerUpsellings = (upselling, productTypes, services) => {
  const enabledPLIsSet = new Set((0, _pli_features.getProductProductFeatures)(productTypes));
  const upsellingPagesToRegister = upsellingPages.reduce((pageUpsellings, {
    pageName,
    pli,
    component
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      pageUpsellings[pageName] = (0, _services.withServicesProvider)(component, services);
    }
    return pageUpsellings;
  }, {});
  const upsellingSectionsToRegister = upsellingSections.reduce((sectionUpsellings, {
    id,
    pli,
    component
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      sectionUpsellings[id] = component;
    }
    return sectionUpsellings;
  }, {});
  const upsellingMessagesToRegister = upsellingMessages.reduce((messagesUpsellings, {
    id,
    pli,
    message
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      messagesUpsellings[id] = message;
    }
    return messagesUpsellings;
  }, {});
  upselling.setPages(upsellingPagesToRegister);
  upselling.setSections(upsellingSectionsToRegister);
  upselling.setMessages(upsellingMessagesToRegister);
};

// Upselling for entire pages, linked to a SecurityPageName
exports.registerUpsellings = registerUpsellings;
const upsellingPages = exports.upsellingPages = [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  pageName: _common.SecurityPageName.entityAnalytics,
  pli: _keys.ProductFeatureKey.advancedInsights,
  component: () => {
    var _getProductTypeByPLI;
    return /*#__PURE__*/_react.default.createElement(_lazy_upselling.EntityAnalyticsUpsellingLazy, {
      requiredProduct: (_getProductTypeByPLI = (0, _use_product_type_by_pli.getProductTypeByPLI)(_keys.ProductFeatureKey.advancedInsights)) !== null && _getProductTypeByPLI !== void 0 ? _getProductTypeByPLI : undefined
    });
  }
}, {
  pageName: _common.SecurityPageName.threatIntelligence,
  pli: _keys.ProductFeatureKey.threatIntelligence,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.ThreatIntelligencePaywallLazy, {
    requiredPLI: _keys.ProductFeatureKey.threatIntelligence
  })
}, {
  pageName: _common.SecurityPageName.exceptions,
  pli: _keys.ProductFeatureKey.endpointExceptions,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.EndpointExceptionsDetailsUpsellingLazy, {
    requiredPLI: _keys.ProductFeatureKey.endpointExceptions
  })
}];

// Upselling for sections, linked by arbitrary ids
const upsellingSections = exports.upsellingSections = [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  id: 'osquery_automated_response_actions',
  pli: _keys.ProductFeatureKey.osqueryAutomatedResponseActions,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.OsqueryResponseActionsUpsellingSectionLazy, {
    requiredPLI: _keys.ProductFeatureKey.osqueryAutomatedResponseActions
  })
}, {
  id: 'endpoint_agent_tamper_protection',
  pli: _keys.ProductFeatureKey.endpointAgentTamperProtection,
  component: _endpoint_management.EndpointAgentTamperProtectionLazy
}, {
  id: 'endpointPolicyProtections',
  pli: _keys.ProductFeatureKey.endpointPolicyProtections,
  component: _endpoint_management.EndpointPolicyProtectionsLazy
}, {
  id: 'ruleDetailsEndpointExceptions',
  pli: _keys.ProductFeatureKey.endpointExceptions,
  component: _endpoint_management.RuleDetailsEndpointExceptionsLazy
}, {
  id: 'endpoint_protection_updates',
  pli: _keys.ProductFeatureKey.endpointProtectionUpdates,
  component: _endpoint_management.EndpointProtectionUpdatesLazy
}];

// Upselling for sections, linked by arbitrary ids
const upsellingMessages = exports.upsellingMessages = [{
  id: 'investigation_guide',
  pli: _keys.ProductFeatureKey.investigationGuide,
  message: (0, _messages.UPGRADE_INVESTIGATION_GUIDE)((_getProductTypeByPLI2 = (0, _use_product_type_by_pli.getProductTypeByPLI)(_keys.ProductFeatureKey.investigationGuide)) !== null && _getProductTypeByPLI2 !== void 0 ? _getProductTypeByPLI2 : '')
}];