"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initSideNavigation = void 0;
var _i18n = require("@kbn/i18n");
var _immer = _interopRequireDefault(require("immer"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROJECT_SETTINGS_TITLE = _i18n.i18n.translate('xpack.securitySolutionServerless.navLinks.projectSettings.title', {
  defaultMessage: 'Project Settings'
});
const initSideNavigation = async services => {
  services.securitySolution.setIsSolutionNavigationEnabled(true);
  const {
    navigationTree$,
    panelContentProvider
  } = await services.securitySolution.getSolutionNavigation();
  const serverlessNavigationTree$ = navigationTree$.pipe((0, _rxjs.map)(navigationTree => (0, _immer.default)(navigationTree, draft => {
    var _draft$footer;
    // Adds serverless cloud links to the footer group ("Product settings" dropdown)
    const footerGroup = (_draft$footer = draft.footer) === null || _draft$footer === void 0 ? void 0 : _draft$footer.find(({
      type
    }) => type === 'navGroup');
    if (footerGroup) {
      footerGroup.title = PROJECT_SETTINGS_TITLE;
      footerGroup.children.push({
        cloudLink: 'userAndRoles',
        openInNewTab: true
      }, {
        cloudLink: 'billingAndSub',
        openInNewTab: true
      });
    }
  })));
  services.serverless.initNavigation('security', serverlessNavigationTree$, {
    panelContentProvider,
    dataTestSubj: 'securitySolutionSideNav'
  });
};
exports.initSideNavigation = initSideNavigation;