"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLI_PRODUCT_FEATURES = void 0;
var _keys = require("@kbn/security-solution-features/keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLI_PRODUCT_FEATURES = exports.PLI_PRODUCT_FEATURES = {
  security: {
    essentials: [_keys.ProductFeatureKey.endpointHostManagement, _keys.ProductFeatureKey.endpointPolicyManagement],
    complete: [_keys.ProductFeatureKey.advancedInsights, _keys.ProductFeatureKey.assistant, _keys.ProductFeatureKey.investigationGuide, _keys.ProductFeatureKey.threatIntelligence, _keys.ProductFeatureKey.casesConnectors, _keys.ProductFeatureKey.externalRuleActions]
  },
  endpoint: {
    essentials: [_keys.ProductFeatureKey.endpointPolicyProtections, _keys.ProductFeatureKey.endpointArtifactManagement, _keys.ProductFeatureKey.endpointExceptions],
    complete: [_keys.ProductFeatureKey.endpointResponseActions, _keys.ProductFeatureKey.osqueryAutomatedResponseActions, _keys.ProductFeatureKey.endpointAgentTamperProtection, _keys.ProductFeatureKey.endpointExceptions, _keys.ProductFeatureKey.endpointProtectionUpdates]
  },
  cloud: {
    essentials: [],
    complete: []
  }
};