"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.productTypes = exports.productType = exports.productTier = exports.productLine = exports.configSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _product = require("./product");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const productLine = exports.productLine = _configSchema.schema.oneOf([_configSchema.schema.literal(_product.ProductLine.security), _configSchema.schema.literal(_product.ProductLine.endpoint), _configSchema.schema.literal(_product.ProductLine.cloud)]);
const productTier = exports.productTier = _configSchema.schema.oneOf([_configSchema.schema.literal(_product.ProductTier.essentials), _configSchema.schema.literal(_product.ProductTier.complete)]);
const productType = exports.productType = _configSchema.schema.object({
  product_line: productLine,
  product_tier: productTier
});
const productTypes = exports.productTypes = _configSchema.schema.arrayOf(productType, {
  defaultValue: []
});
const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  productTypes,
  /**
   * For internal use. A list of string values (comma delimited) that will enable experimental
   * type of functionality that is not yet released. Valid values for this settings need to
   * be defined in:
   * `x-pack/plugins/security_solution_serverless/common/experimental_features.ts`
   * under the `allowedExperimentalValues` object
   *
   * @example
   * xpack.securitySolutionServerless.enableExperimental:
   *   - someCrazyFeature
   *   - someEvenCrazierFeature
   */
  enableExperimental: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: () => []
  })
});