"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewTaskMetricsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _types = require("./types");
var _task_metrics = require("./task_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Preview telemetry events sender for the telemetry route.
 * @see telemetry_detection_rules_preview_route
 */
class PreviewTaskMetricsService {
  constructor(logger, sender) {
    /** Last sent message */
    (0, _defineProperty2.default)(this, "sentMessages", []);
    /** Logger for this class  */
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "composite", void 0);
    this.sender = sender;
    this.logger = logger;
    this.composite = new _task_metrics.TaskMetricsService(logger, sender);
  }
  getSentMessages() {
    return this.sentMessages;
  }
  start(name) {
    this.logger.error('Simulating TaskMetricsService.start');
    return this.composite.start(name);
  }
  createTaskMetric(trace, error) {
    this.logger.error('Simulating TaskMetricsService.createTaskMetric');
    return this.composite.createTaskMetric(trace, error);
  }
  async end(trace, error) {
    this.logger.error('Simulating TaskMetricsService.end');
    const metric = this.composite.createTaskMetric(trace, error);
    const result = this.sender.simulateSendAsync(_types.TelemetryChannel.TASK_METRICS, [metric]);
    this.sentMessages = [...this.sentMessages, ...result];
  }
}
exports.PreviewTaskMetricsService = PreviewTaskMetricsService;