"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.events = exports.createAssetCriticalityProcessedFileEvent = exports.RISK_SCORE_EXECUTION_SUCCESS_EVENT = exports.RISK_SCORE_EXECUTION_ERROR_EVENT = exports.RISK_SCORE_EXECUTION_CANCELLATION_EVENT = exports.ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_SCORE_EXECUTION_SUCCESS_EVENT = exports.RISK_SCORE_EXECUTION_SUCCESS_EVENT = {
  eventType: 'risk_score_execution_success',
  schema: {
    scoresWritten: {
      type: 'long',
      _meta: {
        description: 'Number of risk scores written during this scoring task execution'
      }
    },
    taskDurationInSeconds: {
      type: 'long',
      _meta: {
        description: 'Duration (in seconds) of the current risk scoring task execution'
      }
    },
    interval: {
      type: 'keyword',
      _meta: {
        description: `Configured interval for the current risk scoring task`
      }
    },
    alertSampleSizePerShard: {
      type: 'long',
      _meta: {
        description: `Number of alerts to sample per shard for the current risk scoring task`
      }
    }
  }
};
const RISK_SCORE_EXECUTION_ERROR_EVENT = exports.RISK_SCORE_EXECUTION_ERROR_EVENT = {
  eventType: 'risk_score_execution_error',
  schema: {}
};
const RISK_SCORE_EXECUTION_CANCELLATION_EVENT = exports.RISK_SCORE_EXECUTION_CANCELLATION_EVENT = {
  eventType: 'risk_score_execution_cancellation',
  schema: {
    scoresWritten: {
      type: 'long',
      _meta: {
        description: 'Number of risk scores written during this scoring task execution'
      }
    },
    taskDurationInSeconds: {
      type: 'long',
      _meta: {
        description: 'Duration (in seconds) of the current risk scoring task execution'
      }
    },
    interval: {
      type: 'keyword',
      _meta: {
        description: `Configured interval for the current risk scoring task`
      }
    },
    alertSampleSizePerShard: {
      type: 'long',
      _meta: {
        description: `Number of alerts to sample per shard for the current risk scoring task`
      }
    }
  }
};
const ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT = exports.ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT = {
  eventType: 'Asset Criticality Csv Upload Processed',
  schema: {
    processing: {
      properties: {
        startTime: {
          type: 'date',
          _meta: {
            description: 'Processing start time'
          }
        },
        endTime: {
          type: 'date',
          _meta: {
            description: 'Processing end time'
          }
        },
        tookMs: {
          type: 'long',
          _meta: {
            description: 'How long processing took ms'
          }
        }
      }
    },
    result: {
      properties: {
        successful: {
          type: 'long',
          _meta: {
            description: 'Number of criticality records successfully created or updated'
          }
        },
        failed: {
          type: 'long',
          _meta: {
            description: 'Number of criticality records which had errors'
          }
        },
        total: {
          type: 'long',
          _meta: {
            description: 'Total number of lines in the file'
          }
        }
      }
    },
    status: {
      type: 'keyword',
      _meta: {
        description: 'Status of the processing either success, partial_success or fail'
      }
    }
  }
};
const createAssetCriticalityProcessedFileEvent = ({
  result,
  startTime,
  endTime
}) => {
  const status = getUploadStatus(result);
  const processing = {
    startTime: startTime.toISOString(),
    endTime: endTime.toISOString(),
    tookMs: endTime.getTime() - startTime.getTime()
  };
  return [ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT.eventType, {
    processing,
    result,
    status
  }];
};
exports.createAssetCriticalityProcessedFileEvent = createAssetCriticalityProcessedFileEvent;
const getUploadStatus = stats => {
  if (!stats) {
    return 'fail';
  }
  if (stats.failed === 0) {
    return 'success';
  }
  if (stats.successful > 0) {
    return 'partial_success';
  }
  return 'fail';
};
const events = exports.events = [RISK_SCORE_EXECUTION_SUCCESS_EVENT, RISK_SCORE_EXECUTION_ERROR_EVENT, RISK_SCORE_EXECUTION_CANCELLATION_EVENT, ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT];