"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFleetManagedIndexTemplatesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFleetManagedIndexTemplatesRoute = router => {
  router.versioned.get({
    path: _constants.SECRUTIY_INTEGRATIONS_FLEET_MANAGED_INDEX_TEMPLATES_URL,
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {}
  }, async (context, _request, response) => {
    const intContext = await context.core;
    try {
      const esClient = intContext.elasticsearch.client.asCurrentUser;
      const indexTemplates = (await esClient.indices.getIndexTemplate()).index_templates;
      const fleetManagedIndexTemplates = indexTemplates.filter(t => {
        var _t$index_template$_me;
        return ((_t$index_template$_me = t.index_template._meta) === null || _t$index_template$_me === void 0 ? void 0 : _t$index_template$_me.managed_by) === 'fleet';
      }).map(t => t.name);
      return response.ok({
        body: fleetManagedIndexTemplates
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return response.customError({
        body: {
          message: error.message
        },
        statusCode: error.statusCode
      });
    }
  });
};
exports.getFleetManagedIndexTemplatesRoute = getFleetManagedIndexTemplatesRoute;