"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readPrebuiltDevToolContentRoute = void 0;
var _mustache = _interopRequireDefault(require("mustache"));
var _path = _interopRequireWildcard(require("path"));
var _fs = _interopRequireDefault(require("fs"));
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _console_mappings = require("../console_mappings");
var _risk_score = require("../../../../../common/api/entity_analytics/risk_score");
var _search_strategy = require("../../../../../common/search_strategy");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReadables = dataPath => _fs.default.promises.readFile(dataPath, {
  encoding: 'utf-8'
});
class ConsoleResponseFactory {
  constructor(response) {
    this.response = response;
  }

  // @ts-expect-error upgrade typescript v4.9.5
  error({
    statusCode,
    body,
    headers
  }) {
    // @ts-expect-error upgrade typescript v4.9.5
    const contentType = {
      'content-type': 'text/plain; charset=utf-8'
    };
    // @ts-expect-error upgrade typescript v4.9.5
    const defaultedHeaders = {
      ...contentType,
      ...(headers !== null && headers !== void 0 ? headers : {})
    };
    return this.response.custom({
      headers: defaultedHeaders,
      statusCode,
      // @ts-expect-error upgrade typescript v4.9.5
      body
    });
  }
}
const buildConsoleResponse = response => new ConsoleResponseFactory(response);
const readPrebuiltDevToolContentRoute = router => {
  router.versioned.get({
    access: 'internal',
    path: _constants.DEV_TOOL_PREBUILT_CONTENT,
    options: {
      tags: ['access:securitySolution']
    }
  }).addVersion({
    validate: {
      request: _risk_score.readConsoleRequestBody
    },
    version: '1'
  }, async (context, request, response) => {
    const siemResponse = buildConsoleResponse(response);
    const {
      console_id: consoleId
    } = request.params;
    try {
      var _consoleMappings$cons;
      const securitySolution = await context.securitySolution;
      const spaceId = securitySolution.getSpaceId();
      const fileName = (_consoleMappings$cons = _console_mappings.consoleMappings[consoleId]) !== null && _consoleMappings$cons !== void 0 ? _consoleMappings$cons : null;
      if (!fileName) {
        return siemResponse.error({
          statusCode: 500,
          body: 'No such file or directory'
        });
      }
      const filePath = '../console_templates';
      const dir = (0, _path.resolve)((0, _path.join)(__dirname, filePath));
      const dataPath = _path.default.join(dir, fileName);
      const template = await getReadables(dataPath);
      const riskScoreEntity = consoleId === 'enable_host_risk_score' ? _search_strategy.RiskScoreEntity.host : _search_strategy.RiskScoreEntity.user;
      const view = (0, _utils.getView)({
        spaceId,
        riskScoreEntity
      });

      // override the mustache.js escape function to not escape special characters
      _mustache.default.escape = text => text;
      const output = _mustache.default.render(template, view);
      return response.ok({
        body: output
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.readPrebuiltDevToolContentRoute = readPrebuiltDevToolContentRoute;