"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductFeatures = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _product_features_config_merger = require("./product_features_config_merger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProductFeatures {
  constructor(logger, subFeaturesMap, baseKibanaFeature, baseKibanaSubFeatureIds) {
    (0, _defineProperty2.default)(this, "featureConfigMerger", void 0);
    (0, _defineProperty2.default)(this, "featuresSetup", void 0);
    (0, _defineProperty2.default)(this, "registeredActions", void 0);
    this.logger = logger;
    this.baseKibanaFeature = baseKibanaFeature;
    this.baseKibanaSubFeatureIds = baseKibanaSubFeatureIds;
    this.featureConfigMerger = new _product_features_config_merger.ProductFeaturesConfigMerger(this.logger, subFeaturesMap);
    this.registeredActions = new Set();
  }
  init(featuresSetup) {
    this.featuresSetup = featuresSetup;
  }
  setConfig(productFeatureConfig) {
    if (this.featuresSetup == null) {
      throw new Error('Cannot sync kibana features as featuresSetup is not present. Did you call init?');
    }
    const completeProductFeatureConfig = this.featureConfigMerger.mergeProductFeatureConfigs(this.baseKibanaFeature, this.baseKibanaSubFeatureIds, Array.from(productFeatureConfig.values()));
    this.logger.debug(JSON.stringify(completeProductFeatureConfig));
    this.featuresSetup.registerKibanaFeature(completeProductFeatureConfig);
    this.addRegisteredActions(completeProductFeatureConfig);
  }
  addRegisteredActions(config) {
    var _config$privileges, _config$privileges3, _config$subFeatures;
    const privileges = [];

    // get main privileges
    if ((_config$privileges = config.privileges) !== null && _config$privileges !== void 0 && _config$privileges.all) {
      var _config$privileges2;
      privileges.push((_config$privileges2 = config.privileges) === null || _config$privileges2 === void 0 ? void 0 : _config$privileges2.all);
    }
    if ((_config$privileges3 = config.privileges) !== null && _config$privileges3 !== void 0 && _config$privileges3.read) {
      var _config$privileges4;
      privileges.push((_config$privileges4 = config.privileges) === null || _config$privileges4 === void 0 ? void 0 : _config$privileges4.read);
    }

    // get sub features privileges
    (_config$subFeatures = config.subFeatures) === null || _config$subFeatures === void 0 ? void 0 : _config$subFeatures.forEach(subFeature => {
      subFeature.privilegeGroups.forEach(privilegeGroup => {
        privilegeGroup.privileges.forEach(privilege => {
          privileges.push(privilege);
        });
      });
    });

    // add the actions from all the registered privileges
    privileges.forEach(privilege => {
      var _privilege$api, _privilege$ui;
      (_privilege$api = privilege.api) === null || _privilege$api === void 0 ? void 0 : _privilege$api.forEach(apiAction => {
        this.registeredActions.add(`api:${apiAction}`);
      });
      (_privilege$ui = privilege.ui) === null || _privilege$ui === void 0 ? void 0 : _privilege$ui.forEach(uiAction => {
        this.registeredActions.add(`ui:${uiAction}`);
      });
    });
  }
  isActionRegistered(action) {
    return this.registeredActions.has(action);
  }
}
exports.ProductFeatures = ProductFeatures;