"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskScoreServiceFactory = void 0;
var _calculate_risk_scores = require("./calculate_risk_scores");
var _calculate_and_persist_risk_scores = require("./calculate_and_persist_risk_scores");
var _transforms = require("../utils/transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskScoreServiceFactory = ({
  assetCriticalityService,
  esClient,
  logger,
  riskEngineDataClient,
  riskScoreDataClient,
  spaceId
}) => ({
  calculateScores: params => (0, _calculate_risk_scores.calculateRiskScores)({
    ...params,
    assetCriticalityService,
    esClient,
    logger
  }),
  calculateAndPersistScores: params => (0, _calculate_and_persist_risk_scores.calculateAndPersistRiskScores)({
    ...params,
    assetCriticalityService,
    esClient,
    logger,
    riskScoreDataClient,
    spaceId
  }),
  getConfigurationWithDefaults: async entityAnalyticsConfig => {
    var _savedObjectConfig$al;
    const savedObjectConfig = await riskEngineDataClient.getConfiguration();
    if (!savedObjectConfig) {
      return null;
    }
    const alertSampleSizePerShard = (_savedObjectConfig$al = savedObjectConfig.alertSampleSizePerShard) !== null && _savedObjectConfig$al !== void 0 ? _savedObjectConfig$al : entityAnalyticsConfig.riskEngine.alertSampleSizePerShard;
    return {
      ...savedObjectConfig,
      alertSampleSizePerShard
    };
  },
  getRiskInputsIndex: async params => riskScoreDataClient.getRiskInputsIndex(params),
  scheduleLatestTransformNow: () => (0, _transforms.scheduleLatestTransformNow)({
    namespace: spaceId,
    esClient
  })
});
exports.riskScoreServiceFactory = riskScoreServiceFactory;