"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAssetCriticalityRoutes = void 0;
var _status = require("./status");
var _upsert = require("./upsert");
var _get = require("./get");
var _delete = require("./delete");
var _privileges = require("./privileges");
var _upload_csv = require("./upload_csv");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAssetCriticalityRoutes = ({
  router,
  logger,
  config,
  getStartServices
}) => {
  (0, _status.assetCriticalityStatusRoute)(router, logger);
  (0, _upsert.assetCriticalityUpsertRoute)(router, logger);
  (0, _get.assetCriticalityGetRoute)(router, logger);
  (0, _delete.assetCriticalityDeleteRoute)(router, logger);
  (0, _privileges.assetCriticalityPrivilegesRoute)(router, logger, getStartServices);
  (0, _upload_csv.assetCriticalityCSVUploadRoute)(router, logger, config, getStartServices);
};
exports.registerAssetCriticalityRoutes = registerAssetCriticalityRoutes;