"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapSuppressedAlerts = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _build_bulk_body = require("../factories/utils/build_bulk_body");
var _suppression_utils = require("./suppression_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * wraps suppressed alerts
 * creates instanceId hash, which is used to search on time interval alerts
 * populates alert's suppression fields
 */
const wrapSuppressedAlerts = ({
  events,
  spaceId,
  completeRule,
  mergeStrategy,
  indicesToQuery,
  buildReasonMessage,
  alertTimestampOverride,
  ruleExecutionLogger,
  publicBaseUrl,
  primaryTimestamp,
  secondaryTimestamp
}) => {
  return events.map(event => {
    var _completeRule$rulePar;
    const suppressionTerms = (0, _suppression_utils.getSuppressionTerms)({
      alertSuppression: completeRule === null || completeRule === void 0 ? void 0 : (_completeRule$rulePar = completeRule.ruleParams) === null || _completeRule$rulePar === void 0 ? void 0 : _completeRule$rulePar.alertSuppression,
      fields: event.fields
    });
    const id = (0, _objectHash.default)([event._index, event._id, `${spaceId}:${completeRule.alertId}`, suppressionTerms]);
    const instanceId = (0, _objectHash.default)([suppressionTerms, completeRule.alertId, spaceId]);
    const baseAlert = (0, _build_bulk_body.buildBulkBody)(spaceId, completeRule, event, mergeStrategy, [], true, buildReasonMessage, indicesToQuery, alertTimestampOverride, ruleExecutionLogger, id, publicBaseUrl);
    return {
      _id: id,
      _index: '',
      _source: {
        ...baseAlert,
        ...(0, _suppression_utils.getSuppressionAlertFields)({
          primaryTimestamp,
          secondaryTimestamp,
          fields: event.fields,
          suppressionTerms,
          fallbackTimestamp: baseAlert[_ruleDataUtils.TIMESTAMP],
          instanceId
        })
      }
    };
  });
};
exports.wrapSuppressedAlerts = wrapSuppressedAlerts;