"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEventSignal = void 0;
var _build_threat_mapping_filter = require("./build_threat_mapping_filter");
var _get_filter = require("../../utils/get_filter");
var _search_after_bulk_create = require("../../utils/search_after_bulk_create");
var _reason_formatters = require("../../utils/reason_formatters");
var _get_signals_map_from_threat_index = require("./get_signals_map_from_threat_index");
var _search_after_bulk_create_suppressed_alerts = require("../../utils/search_after_bulk_create_suppressed_alerts");
var _threat_enrichment_factory = require("./threat_enrichment_factory");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEventSignal = async ({
  bulkCreate,
  currentResult,
  currentEventList,
  eventsTelemetry,
  filters,
  inputIndex,
  language,
  listClient,
  query,
  ruleExecutionLogger,
  savedId,
  searchAfterSize,
  services,
  threatMapping,
  tuple,
  type,
  wrapHits,
  wrapSuppressedHits,
  threatQuery,
  threatFilters,
  threatLanguage,
  threatIndex,
  threatIndicatorPath,
  threatPitId,
  reassignThreatPitId,
  runtimeMappings,
  runOpts,
  primaryTimestamp,
  secondaryTimestamp,
  exceptionFilter,
  unprocessedExceptions,
  allowedFieldsForTermsQuery,
  threatMatchedFields,
  inputIndexFields,
  threatIndexFields,
  completeRule,
  sortOrder = 'desc',
  isAlertSuppressionActive,
  experimentalFeatures
}) => {
  var _threatFiltersFromEve;
  const threatFiltersFromEvents = (0, _build_threat_mapping_filter.buildThreatMappingFilter)({
    threatMapping,
    threatList: currentEventList,
    entryKey: 'field',
    allowedFieldsForTermsQuery
  });
  if (!threatFiltersFromEvents.query || ((_threatFiltersFromEve = threatFiltersFromEvents.query) === null || _threatFiltersFromEve === void 0 ? void 0 : _threatFiltersFromEve.bool.should.length) === 0) {
    // empty event list and we do not want to return everything as being
    // a hit so opt to return the existing result.
    ruleExecutionLogger.debug('Indicator items are empty after filtering for missing data, returning without attempting a match');
    return currentResult;
  } else {
    var _threatFiltersFromEve2;
    const threatSearchParams = {
      esClient: services.scopedClusterClient.asCurrentUser,
      threatFilters: [...threatFilters, threatFiltersFromEvents],
      query: threatQuery,
      language: threatLanguage,
      index: threatIndex,
      ruleExecutionLogger,
      threatListConfig: {
        _source: threatMatchedFields.threat,
        fields: undefined
      },
      pitId: threatPitId,
      reassignPitId: reassignThreatPitId,
      runtimeMappings,
      listClient,
      exceptionFilter,
      indexFields: threatIndexFields
    };
    const signalsQueryMap = await (0, _get_signals_map_from_threat_index.getSignalsQueryMapFromThreatIndex)({
      threatSearchParams,
      eventsCount: currentEventList.length,
      signalValueMap: (0, _utils.getSignalValueMap)({
        eventList: currentEventList,
        threatMatchedFields
      }),
      termsQueryAllowed: true
    });
    const ids = Array.from(signalsQueryMap.keys());
    const indexFilter = {
      query: {
        bool: {
          filter: {
            ids: {
              values: ids
            }
          }
        }
      }
    };
    const esFilter = await (0, _get_filter.getFilter)({
      type,
      filters: [...filters, indexFilter],
      language,
      query,
      savedId,
      services,
      index: inputIndex,
      exceptionFilter,
      fields: inputIndexFields
    });
    ruleExecutionLogger.debug(`${ids === null || ids === void 0 ? void 0 : ids.length} matched signals found`);
    const enrichment = (0, _threat_enrichment_factory.threatEnrichmentFactory)({
      signalsQueryMap,
      threatIndicatorPath,
      threatFilters,
      threatSearchParams
    });
    let createResult;
    const searchAfterBulkCreateParams = {
      buildReasonMessage: _reason_formatters.buildReasonMessageForThreatMatchAlert,
      bulkCreate,
      enrichment,
      eventsTelemetry,
      exceptionsList: unprocessedExceptions,
      filter: esFilter,
      inputIndexPattern: inputIndex,
      listClient,
      pageSize: searchAfterSize,
      ruleExecutionLogger,
      services,
      sortOrder,
      trackTotalHits: false,
      tuple,
      wrapHits,
      runtimeMappings,
      primaryTimestamp,
      secondaryTimestamp
    };
    if (isAlertSuppressionActive) {
      createResult = await (0, _search_after_bulk_create_suppressed_alerts.searchAfterAndBulkCreateSuppressedAlerts)({
        ...searchAfterBulkCreateParams,
        wrapSuppressedHits,
        alertTimestampOverride: runOpts.alertTimestampOverride,
        alertWithSuppression: runOpts.alertWithSuppression,
        alertSuppression: completeRule.ruleParams.alertSuppression,
        experimentalFeatures
      });
    } else {
      createResult = await (0, _search_after_bulk_create.searchAfterAndBulkCreate)(searchAfterBulkCreateParams);
    }
    ruleExecutionLogger.debug(`${(_threatFiltersFromEve2 = threatFiltersFromEvents.query) === null || _threatFiltersFromEve2 === void 0 ? void 0 : _threatFiltersFromEve2.bool.should.length} items have completed match checks and the total times to search were ${createResult.searchAfterTimes.length !== 0 ? createResult.searchAfterTimes : '(unknown) '}ms`);
    return createResult;
  }
};
exports.createEventSignal = createEventSignal;