"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIndicatorMatchAlertType = void 0;
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../../../../../common/constants");
var _rule_schema = require("../../rule_schema");
var _indicator_match = require("./indicator_match");
var _utils = require("../utils");
var _wrap_suppressed_alerts = require("../utils/wrap_suppressed_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createIndicatorMatchAlertType = createOptions => {
  const {
    eventsTelemetry,
    version,
    licensing,
    experimentalFeatures
  } = createOptions;
  return {
    id: _securitysolutionRules.INDICATOR_RULE_TYPE_ID,
    name: 'Indicator Match Rule',
    ruleTaskTimeout: '1h',
    validate: {
      params: {
        validate: object => {
          return _rule_schema.ThreatRuleParams.parse(object);
        },
        /**
         * validate rule params when rule is bulk edited (update and created in future as well)
         * returned params can be modified (useful in case of version increment)
         * @param mutatedRuleParams
         * @returns mutatedRuleParams
         */
        validateMutatedParams: mutatedRuleParams => {
          (0, _utils.validateIndexPatterns)(mutatedRuleParams.index);
          return mutatedRuleParams;
        }
      }
    },
    schemas: {
      params: {
        type: 'zod',
        schema: _rule_schema.ThreatRuleParams
      }
    },
    actionGroups: [{
      id: 'default',
      name: 'Default'
    }],
    defaultActionGroupId: 'default',
    actionVariables: {
      context: [{
        name: 'server',
        description: 'the server'
      }]
    },
    minimumLicenseRequired: 'basic',
    isExportable: false,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    producer: _constants.SERVER_APP_ID,
    async executor(execOptions) {
      const {
        runOpts: {
          inputIndex,
          runtimeMappings,
          completeRule,
          tuple,
          listClient,
          ruleExecutionLogger,
          searchAfterSize,
          bulkCreate,
          wrapHits,
          primaryTimestamp,
          secondaryTimestamp,
          exceptionFilter,
          unprocessedExceptions,
          inputIndexFields
        },
        services,
        spaceId,
        state
      } = execOptions;
      const runOpts = execOptions.runOpts;
      const wrapSuppressedHits = (events, buildReasonMessage) => (0, _wrap_suppressed_alerts.wrapSuppressedAlerts)({
        events,
        spaceId,
        completeRule,
        mergeStrategy: runOpts.mergeStrategy,
        indicesToQuery: runOpts.inputIndex,
        buildReasonMessage,
        alertTimestampOverride: runOpts.alertTimestampOverride,
        ruleExecutionLogger,
        publicBaseUrl: runOpts.publicBaseUrl,
        primaryTimestamp,
        secondaryTimestamp
      });
      const result = await (0, _indicator_match.indicatorMatchExecutor)({
        inputIndex,
        runtimeMappings,
        completeRule,
        tuple,
        listClient,
        services,
        version,
        searchAfterSize,
        ruleExecutionLogger,
        eventsTelemetry,
        bulkCreate,
        wrapHits,
        primaryTimestamp,
        secondaryTimestamp,
        exceptionFilter,
        unprocessedExceptions,
        inputIndexFields,
        wrapSuppressedHits,
        runOpts,
        licensing,
        experimentalFeatures
      });
      return {
        ...result,
        state
      };
    }
  };
};
exports.createIndicatorMatchAlertType = createIndicatorMatchAlertType;