"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEsqlSearchRequest = void 0;
var _build_events_query = require("../utils/build_events_query");
var _get_query_filter = require("../utils/get_query_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildEsqlSearchRequest = ({
  query,
  from,
  to,
  filters,
  primaryTimestamp,
  secondaryTimestamp,
  exceptionFilter,
  size
}) => {
  const esFilter = (0, _get_query_filter.getQueryFilter)({
    query: '',
    language: 'esql',
    filters: filters || [],
    index: undefined,
    exceptionFilter
  });
  const rangeFilter = (0, _build_events_query.buildTimeRangeFilter)({
    to,
    from,
    primaryTimestamp,
    secondaryTimestamp
  });
  const requestFilter = [rangeFilter, esFilter];
  return {
    // we limit size of the response to maxAlertNumber + 1
    // ES|QL currently does not support pagination and returns 10,000 results
    query: `${query} | limit ${size + 1}`,
    filter: {
      bool: {
        filter: requestFilter
      }
    }
  };
};
exports.buildEsqlSearchRequest = buildEsqlSearchRequest;