"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEqlAlertType = void 0;
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../../../../../common/constants");
var _rule_schema = require("../../rule_schema");
var _eql = require("./eql");
var _utils = require("../utils");
var _wrap_suppressed_alerts = require("../utils/wrap_suppressed_alerts");
var _get_is_alert_suppression_active = require("../utils/get_is_alert_suppression_active");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEqlAlertType = createOptions => {
  const {
    experimentalFeatures,
    version,
    licensing
  } = createOptions;
  return {
    id: _securitysolutionRules.EQL_RULE_TYPE_ID,
    name: 'Event Correlation Rule',
    validate: {
      params: {
        validate: object => {
          return _rule_schema.EqlRuleParams.parse(object);
        },
        /**
         * validate rule params when rule is bulk edited (update and created in future as well)
         * returned params can be modified (useful in case of version increment)
         * @param mutatedRuleParams
         * @returns mutatedRuleParams
         */
        validateMutatedParams: mutatedRuleParams => {
          (0, _utils.validateIndexPatterns)(mutatedRuleParams.index);
          return mutatedRuleParams;
        }
      }
    },
    schemas: {
      params: {
        type: 'zod',
        schema: _rule_schema.EqlRuleParams
      }
    },
    actionGroups: [{
      id: 'default',
      name: 'Default'
    }],
    defaultActionGroupId: 'default',
    actionVariables: {
      context: [{
        name: 'server',
        description: 'the server'
      }]
    },
    minimumLicenseRequired: 'basic',
    isExportable: false,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    producer: _constants.SERVER_APP_ID,
    async executor(execOptions) {
      const {
        runOpts: {
          completeRule,
          tuple,
          inputIndex,
          runtimeMappings,
          ruleExecutionLogger,
          bulkCreate,
          wrapHits,
          wrapSequences,
          primaryTimestamp,
          secondaryTimestamp,
          exceptionFilter,
          unprocessedExceptions,
          mergeStrategy,
          alertTimestampOverride,
          publicBaseUrl,
          alertWithSuppression
        },
        services,
        state,
        spaceId
      } = execOptions;
      const wrapSuppressedHits = (events, buildReasonMessage) => (0, _wrap_suppressed_alerts.wrapSuppressedAlerts)({
        events,
        spaceId,
        completeRule,
        mergeStrategy,
        indicesToQuery: inputIndex,
        buildReasonMessage,
        alertTimestampOverride,
        ruleExecutionLogger,
        publicBaseUrl,
        primaryTimestamp,
        secondaryTimestamp
      });
      const isNonSeqAlertSuppressionActive = await (0, _get_is_alert_suppression_active.getIsAlertSuppressionActive)({
        alertSuppression: completeRule.ruleParams.alertSuppression,
        licensing
      });
      const result = await (0, _eql.eqlExecutor)({
        completeRule,
        tuple,
        inputIndex,
        runtimeMappings,
        ruleExecutionLogger,
        services,
        version,
        bulkCreate,
        wrapHits,
        wrapSequences,
        primaryTimestamp,
        secondaryTimestamp,
        exceptionFilter,
        unprocessedExceptions,
        wrapSuppressedHits,
        alertTimestampOverride,
        alertWithSuppression,
        isAlertSuppressionActive: isNonSeqAlertSuppressionActive,
        experimentalFeatures
      });
      return {
        ...result,
        state
      };
    }
  };
};
exports.createEqlAlertType = createEqlAlertType;