"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIndexPatternsBulkEditAction = void 0;
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * helper utility that defines whether bulk edit action is related to index patterns, i.e. one of:
 * 'add_index_patterns', 'delete_index_patterns', 'set_index_patterns'
 * @param editAction {@link BulkActionEditType}
 * @returns {boolean}
 */
const isIndexPatternsBulkEditAction = editAction => {
  const indexPatternsActions = [_rule_management.BulkActionEditTypeEnum.add_index_patterns, _rule_management.BulkActionEditTypeEnum.delete_index_patterns, _rule_management.BulkActionEditTypeEnum.set_index_patterns];
  return indexPatternsActions.includes(editAction);
};
exports.isIndexPatternsBulkEditAction = isIndexPatternsBulkEditAction;