"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchRulesByQueryOrIds = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../../../common/constants");
var _promise_pool = require("../../../../../../utils/promise_pool");
var _read_rules = require("../../../logic/crud/read_rules");
var _find_rules = require("../../../logic/search/find_rules");
var _route = require("./route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchRulesByQueryOrIds = async ({
  query,
  ids,
  rulesClient,
  abortSignal
}) => {
  if (ids) {
    return (0, _promise_pool.initPromisePool)({
      concurrency: _constants.MAX_RULES_TO_UPDATE_IN_PARALLEL,
      items: ids,
      executor: async id => {
        const rule = await (0, _read_rules.readRules)({
          id,
          rulesClient,
          ruleId: undefined
        });
        if (rule == null) {
          throw Error('Rule not found');
        }
        return rule;
      },
      abortSignal
    });
  }
  const {
    data,
    total
  } = await (0, _find_rules.findRules)({
    rulesClient,
    perPage: _route.MAX_RULES_TO_PROCESS_TOTAL,
    filter: query,
    page: undefined,
    sortField: undefined,
    sortOrder: undefined,
    fields: undefined
  });
  if (total > _route.MAX_RULES_TO_PROCESS_TOTAL) {
    throw new _securitysolutionEsUtils.BadRequestError(`More than ${_route.MAX_RULES_TO_PROCESS_TOTAL} rules matched the filter query. Try to narrow it down.`);
  }
  return {
    results: data.map(rule => ({
      item: rule.id,
      result: rule
    })),
    errors: []
  };
};
exports.fetchRulesByQueryOrIds = fetchRulesByQueryOrIds;