"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrebuiltRuleObjectsClient = void 0;
var _with_security_span = require("../../../../../utils/with_security_span");
var _find_rules = require("../../../rule_management/logic/search/find_rules");
var _get_existing_prepackaged_rules = require("../../../rule_management/logic/search/get_existing_prepackaged_rules");
var _rule_converters = require("../../../rule_management/normalization/rule_converters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPrebuiltRuleObjectsClient = rulesClient => {
  return {
    fetchAllInstalledRules: () => {
      return (0, _with_security_span.withSecuritySpan)('IPrebuiltRuleObjectsClient.fetchInstalledRules', async () => {
        const rulesData = await (0, _get_existing_prepackaged_rules.getExistingPrepackagedRules)({
          rulesClient
        });
        const rules = rulesData.map(rule => (0, _rule_converters.internalRuleToAPIResponse)(rule));
        return rules;
      });
    },
    fetchInstalledRulesByIds: ruleIds => {
      return (0, _with_security_span.withSecuritySpan)('IPrebuiltRuleObjectsClient.fetchInstalledRulesByIds', async () => {
        const {
          data
        } = await (0, _find_rules.findRules)({
          rulesClient,
          perPage: ruleIds.length,
          page: 1,
          sortField: 'createdAt',
          sortOrder: 'desc',
          fields: undefined,
          filter: `alert.attributes.params.ruleId:(${ruleIds.join(' or ')})`
        });
        const rules = data.map(rule => (0, _rule_converters.internalRuleToAPIResponse)(rule));
        return rules;
      });
    }
  };
};
exports.createPrebuiltRuleObjectsClient = createPrebuiltRuleObjectsClient;