"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPrebuiltRulesRoutes = void 0;
var _get_prebuilt_rules_and_timelines_status_route = require("./get_prebuilt_rules_and_timelines_status/get_prebuilt_rules_and_timelines_status_route");
var _get_prebuilt_rules_status_route = require("./get_prebuilt_rules_status/get_prebuilt_rules_status_route");
var _install_prebuilt_rules_and_timelines_route = require("./install_prebuilt_rules_and_timelines/install_prebuilt_rules_and_timelines_route");
var _review_rule_installation_route = require("./review_rule_installation/review_rule_installation_route");
var _review_rule_upgrade_route = require("./review_rule_upgrade/review_rule_upgrade_route");
var _perform_rule_installation_route = require("./perform_rule_installation/perform_rule_installation_route");
var _perform_rule_upgrade_route = require("./perform_rule_upgrade/perform_rule_upgrade_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerPrebuiltRulesRoutes = (router, security) => {
  // Legacy endpoints that we're going to deprecate
  (0, _get_prebuilt_rules_and_timelines_status_route.getPrebuiltRulesAndTimelinesStatusRoute)(router, security);
  (0, _install_prebuilt_rules_and_timelines_route.installPrebuiltRulesAndTimelinesRoute)(router);

  // New endpoints for the rule upgrade and installation workflows
  (0, _get_prebuilt_rules_status_route.getPrebuiltRulesStatusRoute)(router);
  (0, _perform_rule_installation_route.performRuleInstallationRoute)(router);
  (0, _perform_rule_upgrade_route.performRuleUpgradeRoute)(router);
  (0, _review_rule_installation_route.reviewRuleInstallationRoute)(router);
  (0, _review_rule_upgrade_route.reviewRuleUpgradeRoute)(router);
};
exports.registerPrebuiltRulesRoutes = registerPrebuiltRulesRoutes;