"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedManifestClient = exports.UNIFIED_MANIFEST_ALL_NAMESPACES = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _create_so_find_iterable = require("../../utils/create_so_find_iterable");
var _utils = require("./utils");
var _artifacts = require("../../lib/artifacts");
var _normalize_kuery = require("../../utils/normalize_kuery");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNIFIED_MANIFEST_ALL_NAMESPACES = exports.UNIFIED_MANIFEST_ALL_NAMESPACES = '*';
class UnifiedManifestClient {
  constructor(savedObjectsClient) {
    (0, _defineProperty2.default)(this, "savedObjectsClient", void 0);
    this.savedObjectsClient = savedObjectsClient;
  }

  /**
   * Create
   */

  createUnifiedManifest(manifest) {
    return this.createUnifiedManifests([manifest]);
  }
  createUnifiedManifests(manifests) {
    return this.savedObjectsClient.bulkCreate(manifests.map(attributes => ({
      type: _artifacts.ManifestConstants.UNIFIED_SAVED_OBJECT_TYPE,
      attributes
    })), {
      initialNamespaces: [UNIFIED_MANIFEST_ALL_NAMESPACES]
    });
  }

  /**
   * Read
   */

  getUnifiedManifestByPolicyId(policyId) {
    return this.savedObjectsClient.find({
      type: _artifacts.ManifestConstants.UNIFIED_SAVED_OBJECT_TYPE,
      search: policyId,
      searchFields: ['policyId'],
      namespaces: [UNIFIED_MANIFEST_ALL_NAMESPACES]
    });
  }
  getUnifiedManifestById(manifestId) {
    return this.getUnifiedManifestByIds([manifestId]);
  }
  getUnifiedManifestByIds(manifestIds) {
    return this.savedObjectsClient.bulkGet(manifestIds.map(id => ({
      id,
      type: _artifacts.ManifestConstants.UNIFIED_SAVED_OBJECT_TYPE
    })), {
      namespace: UNIFIED_MANIFEST_ALL_NAMESPACES
    });
  }
  async getAllUnifiedManifests(cb, options) {
    const unifiedManifestsFetcher = this.fetchAllUnifiedManifests(this.savedObjectsClient, options);
    for await (const unifiedManifests of unifiedManifestsFetcher) {
      if (cb.constructor.name === 'AsyncFunction') {
        await cb(unifiedManifests);
      } else {
        cb(unifiedManifests);
      }
    }
  }

  /**
   * Update
   */

  updateUnifiedManifest(manifest, opts) {
    return this.updateUnifiedManifests([{
      ...manifest,
      ...(opts !== null && opts !== void 0 && opts.version ? {
        version: opts.version
      } : {})
    }]);
  }
  updateUnifiedManifests(manifests) {
    return this.savedObjectsClient.bulkUpdate(manifests.map(manifest => {
      const {
        id,
        version,
        ...attributes
      } = manifest;
      return {
        type: _artifacts.ManifestConstants.UNIFIED_SAVED_OBJECT_TYPE,
        id,
        attributes,
        ...(version ? {
          version
        } : {})
      };
    }), {
      namespace: UNIFIED_MANIFEST_ALL_NAMESPACES
    });
  }

  /**
   * Delete
   */

  deleteUnifiedManifestById(manifestId) {
    return this.deleteUnifiedManifestByIds([manifestId]);
  }
  deleteUnifiedManifestByIds(manifestIds) {
    return this.savedObjectsClient.bulkDelete(manifestIds.map(id => ({
      id,
      type: _artifacts.ManifestConstants.UNIFIED_SAVED_OBJECT_TYPE
    })), {
      namespace: UNIFIED_MANIFEST_ALL_NAMESPACES
    });
  }

  /**
   * Utils
   */

  fetchAllUnifiedManifests(soClient, {
    perPage = 1000,
    fields = [],
    kuery,
    sortOrder = 'asc',
    sortField = 'created'
  } = {}) {
    return (0, _create_so_find_iterable.createSoFindIterable)({
      soClient,
      findRequest: {
        type: _artifacts.ManifestConstants.UNIFIED_SAVED_OBJECT_TYPE,
        perPage,
        filter: kuery ? (0, _normalize_kuery.normalizeKuery)(_artifacts.ManifestConstants.UNIFIED_SAVED_OBJECT_TYPE, kuery) : undefined,
        sortOrder,
        sortField,
        fields,
        namespaces: [UNIFIED_MANIFEST_ALL_NAMESPACES]
      },
      resultsMapper(results) {
        return results.saved_objects.map(_utils.mapUnifiedManifestSavedObjectToUnifiedManifest);
      }
    });
  }
}
exports.UnifiedManifestClient = UnifiedManifestClient;