"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchActionResponses = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _constants = require("./constants");
var _utils = require("../../utils");
var _constants2 = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetch Response Action responses
 */
const fetchActionResponses = async ({
  esClient,
  actionIds = [],
  agentIds = []
}) => {
  var _fleetResponses$hits$, _fleetResponses$hits, _endpointResponses$hi, _endpointResponses$hi2;
  const filter = [];
  if (agentIds !== null && agentIds !== void 0 && agentIds.length) {
    filter.push({
      terms: {
        agent_id: agentIds
      }
    });
  }
  if (actionIds.length) {
    filter.push({
      terms: {
        action_id: actionIds
      }
    });
  }
  const query = {
    bool: {
      filter
    }
  };

  // Get the Action Response(s) from both the Fleet action response index and the Endpoint
  // action response index.
  // We query both indexes separately in order to ensure they are both queried - example if the
  // Fleet actions responses index does not exist yet, ES would generate a `404` and would
  // never actually query the Endpoint Actions index. With support for 3rd party response
  // actions, we need to ensure that both indexes are queried.
  const [fleetResponses, endpointResponses] = await Promise.all([
  // Responses in Fleet index
  esClient.search({
    index: _common.AGENT_ACTIONS_RESULTS_INDEX,
    size: _constants.ACTIONS_SEARCH_PAGE_SIZE,
    body: {
      query
    }
  }, {
    ignore: [404]
  }).catch(_utils.catchAndWrapError),
  // Responses in Endpoint index
  esClient.search({
    index: _constants2.ENDPOINT_ACTION_RESPONSES_INDEX_PATTERN,
    size: _constants.ACTIONS_SEARCH_PAGE_SIZE,
    body: {
      query
    }
  }, {
    ignore: [404]
  }).catch(_utils.catchAndWrapError)]);
  return {
    data: [...((_fleetResponses$hits$ = fleetResponses === null || fleetResponses === void 0 ? void 0 : (_fleetResponses$hits = fleetResponses.hits) === null || _fleetResponses$hits === void 0 ? void 0 : _fleetResponses$hits.hits) !== null && _fleetResponses$hits$ !== void 0 ? _fleetResponses$hits$ : []), ...((_endpointResponses$hi = endpointResponses === null || endpointResponses === void 0 ? void 0 : (_endpointResponses$hi2 = endpointResponses.hits) === null || _endpointResponses$hi2 === void 0 ? void 0 : _endpointResponses$hi2.hits) !== null && _endpointResponses$hi !== void 0 ? _endpointResponses$hi : [])]
  };
};
exports.fetchActionResponses = fetchActionResponses;