"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionDetailsById = void 0;
var _fetch_action_responses = require("./fetch_action_responses");
var _constants = require("../../../../common/endpoint/constants");
var _utils = require("./utils");
var _utils2 = require("../../utils");
var _errors = require("../../../../common/endpoint/errors");
var _errors2 = require("../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get Action Details for a single action id
 * @param esClient
 * @param metadataService
 * @param actionId
 */
const getActionDetailsById = async (esClient, metadataService, actionId) => {
  let actionRequestsLogEntries;
  let normalizedActionRequest;
  let actionResponses;
  try {
    var _actionRequestEsSearc, _actionRequestEsSearc2, _actionRequestsLogEnt;
    // Get both the Action Request(s) and action Response(s)
    const [actionRequestEsSearchResults, allResponseEsHits] = await Promise.all([
    // Get the action request(s)
    esClient.search({
      index: _constants.ENDPOINT_ACTIONS_INDEX,
      body: {
        query: {
          bool: {
            filter: [{
              term: {
                action_id: actionId
              }
            }]
          }
        }
      }
    }, {
      ignore: [404]
    }).catch(_utils2.catchAndWrapError), (0, _fetch_action_responses.fetchActionResponses)({
      esClient,
      actionIds: [actionId]
    }).then(response => response.data)]);
    actionRequestsLogEntries = (0, _utils.formatEndpointActionResults)((_actionRequestEsSearc = actionRequestEsSearchResults === null || actionRequestEsSearchResults === void 0 ? void 0 : (_actionRequestEsSearc2 = actionRequestEsSearchResults.hits) === null || _actionRequestEsSearc2 === void 0 ? void 0 : _actionRequestEsSearc2.hits) !== null && _actionRequestEsSearc !== void 0 ? _actionRequestEsSearc : []);

    // Multiple Action records could have been returned, but we only really
    // need one since they both hold similar data
    const actionDoc = (_actionRequestsLogEnt = actionRequestsLogEntries[0]) === null || _actionRequestsLogEnt === void 0 ? void 0 : _actionRequestsLogEnt.item.data;
    if (actionDoc) {
      normalizedActionRequest = (0, _utils.mapToNormalizedActionRequest)(actionDoc);
    }
    actionResponses = (0, _utils.categorizeResponseResults)({
      results: allResponseEsHits
    });
  } catch (error) {
    throw new _errors.EndpointError(error.message, error);
  }

  // If action id was not found, error out
  if (!normalizedActionRequest) {
    throw new _errors2.NotFoundError(`Action with id '${actionId}' not found.`);
  }

  // get host metadata info with queried agents
  const agentsHostInfo = normalizedActionRequest.agentType === 'endpoint' ? await (0, _utils.getAgentHostNamesWithIds)({
    esClient,
    metadataService,
    agentIds: normalizedActionRequest.agents
  }) : {};
  return (0, _utils.createActionDetailsRecord)(normalizedActionRequest, actionResponses, agentsHostInfo);
};
exports.getActionDetailsById = getActionDetailsById;