"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerActionAuditLogRoutes = registerActionAuditLogRoutes;
var _endpoint = require("../../../../common/api/endpoint");
var _constants = require("../../../../common/endpoint/constants");
var _audit_log_handler = require("./audit_log_handler");
var _with_endpoint_authz = require("../with_endpoint_authz");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Registers the endpoint activity_log route
 * @deprecated
 * @removeBy 9.0.0
 *
 */
function registerActionAuditLogRoutes(router, endpointContext) {
  router.versioned.get({
    access: 'public',
    path: _constants.ENDPOINT_ACTION_LOG_ROUTE,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: _endpoint.EndpointActionLogRequestSchema
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canIsolateHost']
  }, endpointContext.logFactory.get('hostIsolationLogs'), (0, _audit_log_handler.auditLogRequestHandler)(endpointContext)));
}