"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_AND_ACKNOWLEDGED_ALERTS_TOOL_DESCRIPTION = exports.OPEN_AND_ACKNOWLEDGED_ALERTS_TOOL = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _tools = require("@langchain/core/tools");
var _helpers = require("@kbn/elastic-assistant-plugin/server/lib/langchain/helpers");
var _get_open_and_acknowledged_alerts_query = require("./get_open_and_acknowledged_alerts_query");
var _helpers2 = require("./helpers");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_AND_ACKNOWLEDGED_ALERTS_TOOL_DESCRIPTION = exports.OPEN_AND_ACKNOWLEDGED_ALERTS_TOOL_DESCRIPTION = 'Call this for knowledge about the latest n open and acknowledged alerts (sorted by `kibana.alert.risk_score`) in the environment, or when answering questions about open alerts. Input should be a string.';

/**
 * Returns a tool for querying open and acknowledged alerts, or null if the
 * request doesn't have all the required parameters.
 */
const OPEN_AND_ACKNOWLEDGED_ALERTS_TOOL = exports.OPEN_AND_ACKNOWLEDGED_ALERTS_TOOL = {
  id: 'open-and-acknowledged-alerts-tool',
  name: 'OpenAndAcknowledgedAlertsTool',
  description: OPEN_AND_ACKNOWLEDGED_ALERTS_TOOL_DESCRIPTION,
  sourceRegister: _common.APP_UI_ID,
  isSupported: params => {
    const {
      alertsIndexPattern,
      request,
      size
    } = params;
    return (0, _helpers.requestHasRequiredAnonymizationParams)(request) && alertsIndexPattern != null && size != null && !(0, _helpers2.sizeIsOutOfRange)(size);
  },
  getTool(params) {
    if (!this.isSupported(params)) return null;
    const {
      alertsIndexPattern,
      anonymizationFields,
      esClient,
      onNewReplacements,
      replacements,
      size
    } = params;
    return new _tools.DynamicTool({
      name: 'OpenAndAcknowledgedAlertsTool',
      description: OPEN_AND_ACKNOWLEDGED_ALERTS_TOOL_DESCRIPTION,
      func: async () => {
        var _result$hits, _result$hits$hits;
        const query = (0, _get_open_and_acknowledged_alerts_query.getOpenAndAcknowledgedAlertsQuery)({
          alertsIndexPattern,
          anonymizationFields: anonymizationFields !== null && anonymizationFields !== void 0 ? anonymizationFields : [],
          size
        });
        const result = await esClient.search(query);

        // Accumulate replacements locally so we can, for example use the same
        // replacement for a hostname when we see it in multiple alerts:
        let localReplacements = replacements !== null && replacements !== void 0 ? replacements : {};
        const localOnNewReplacements = newReplacements => {
          localReplacements = {
            ...localReplacements,
            ...newReplacements
          };
          onNewReplacements === null || onNewReplacements === void 0 ? void 0 : onNewReplacements(localReplacements); // invoke the callback with the latest replacements
          return Promise.resolve(localReplacements);
        };
        return JSON.stringify((_result$hits = result.hits) === null || _result$hits === void 0 ? void 0 : (_result$hits$hits = _result$hits.hits) === null || _result$hits$hits === void 0 ? void 0 : _result$hits$hits.map(x => (0, _elasticAssistantCommon.transformRawData)({
          anonymizationFields,
          currentReplacements: localReplacements,
          // <-- the latest local replacements
          getAnonymizedValue: _elasticAssistantCommon.getAnonymizedValue,
          onNewReplacements: localOnNewReplacements,
          // <-- the local callback
          rawData: (0, _helpers2.getRawDataOrDefault)(x.fields)
        })));
      },
      tags: ['alerts', 'open-and-acknowledged-alerts']
    });
  }
};