"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timelines = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _timeline = require("../../../common/api/timeline");
var _timelines_page = require("./timelines_page");
var _helpers = require("../../common/components/link_to/helpers");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelinesPagePath = `${_constants.TIMELINES_PATH}/:tabName(${_timeline.TimelineType.default}|${_timeline.TimelineType.template})`;
const timelinesDefaultPath = `${_constants.TIMELINES_PATH}/${_timeline.TimelineType.default}`;
const Timelines = exports.Timelines = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: timelinesPagePath
}, /*#__PURE__*/_react.default.createElement(_timelines_page.TimelinesPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: _constants.TIMELINES_PATH,
  render: ({
    location: {
      search = ''
    }
  }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `${timelinesDefaultPath}${(0, _helpers.appendSearch)(search)}`
  })
})));
Timelines.displayName = 'Timelines';