"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetAllTimeline = exports.getAllTimeline = exports.ALL_TIMELINE_QUERY_ID = void 0;
var _fp = require("lodash/fp");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _react = require("react");
var _reactRedux = require("react-redux");
var _helpers = require("../helpers");
var _constants = require("../../../common/store/inputs/constants");
var _toasters = require("../../../common/components/toasters");
var _inputs = require("../../../common/store/inputs");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _timeline = require("../../../../common/api/timeline");
var _api = require("../api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALL_TIMELINE_QUERY_ID = exports.ALL_TIMELINE_QUERY_ID = 'FETCH_ALL_TIMELINES';
const getAllTimeline = exports.getAllTimeline = (0, _memoizeOne.default)((_variables, timelines) => timelines.map(timeline => {
  var _timeline$timelineTyp;
  return {
    created: timeline.created,
    description: timeline.description,
    eventIdToNoteIds: timeline.eventIdToNoteIds != null ? timeline.eventIdToNoteIds.reduce((acc, note) => {
      if (note.eventId != null) {
        const notes = (0, _fp.getOr)([], note.eventId, acc);
        return {
          ...acc,
          [note.eventId]: [...notes, note.noteId]
        };
      }
      return acc;
    }, {}) : null,
    excludedRowRendererIds: timeline.excludedRowRendererIds,
    favorite: timeline.favorite,
    noteIds: timeline.noteIds,
    notes: timeline.notes != null ? timeline.notes.map(note => ({
      ...note,
      savedObjectId: note.noteId
    })) : null,
    pinnedEventIds: timeline.pinnedEventIds != null ? timeline.pinnedEventIds.reduce((acc, pinnedEventId) => ({
      ...acc,
      [pinnedEventId]: true
    }), {}) : null,
    savedObjectId: timeline.savedObjectId,
    savedSearchId: timeline.savedSearchId,
    status: timeline.status,
    title: timeline.title,
    updated: timeline.updated,
    updatedBy: timeline.updatedBy,
    timelineType: (_timeline$timelineTyp = timeline.timelineType) !== null && _timeline$timelineTyp !== void 0 ? _timeline$timelineTyp : _timeline.TimelineType.default,
    templateTimelineId: timeline.templateTimelineId,
    queryType: (0, _helpers.getTimelineQueryTypes)(timeline)
  };
}));
const useGetAllTimeline = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [, dispatchToaster] = (0, _toasters.useStateToaster)();
  const [allTimelines, setAllTimelines] = (0, _react.useState)({
    loading: false,
    totalCount: 0,
    timelines: null,
    // use null as initial state to distinguish between empty result and haven't started loading.
    customTemplateTimelineCount: 0,
    defaultTimelineCount: 0,
    elasticTemplateTimelineCount: 0,
    templateTimelineCount: 0,
    favoriteCount: 0
  });
  const fetchAllTimeline = (0, _react.useCallback)(async ({
    onlyUserFavorite,
    pageInfo,
    search,
    sort,
    status,
    timelineType
  }) => {
    let didCancel = false;
    const abortCtrl = new AbortController();
    const fetchData = async () => {
      try {
        var _getAllTimelineRespon, _getAllTimelineRespon2, _getAllTimelineRespon3, _getAllTimelineRespon4, _getAllTimelineRespon5, _getAllTimelineRespon6, _getAllTimelineRespon7;
        setAllTimelines(prevState => ({
          ...prevState,
          loading: true
        }));
        const variables = {
          onlyUserFavorite,
          pageInfo,
          search,
          sort,
          status,
          timelineType
        };
        const getAllTimelineResponse = await (0, _api.getAllTimelines)(variables, abortCtrl.signal);
        const totalCount = (_getAllTimelineRespon = getAllTimelineResponse === null || getAllTimelineResponse === void 0 ? void 0 : getAllTimelineResponse.totalCount) !== null && _getAllTimelineRespon !== void 0 ? _getAllTimelineRespon : 0;
        const timelines = (_getAllTimelineRespon2 = getAllTimelineResponse === null || getAllTimelineResponse === void 0 ? void 0 : getAllTimelineResponse.timeline) !== null && _getAllTimelineRespon2 !== void 0 ? _getAllTimelineRespon2 : [];
        const customTemplateTimelineCount = (_getAllTimelineRespon3 = getAllTimelineResponse === null || getAllTimelineResponse === void 0 ? void 0 : getAllTimelineResponse.customTemplateTimelineCount) !== null && _getAllTimelineRespon3 !== void 0 ? _getAllTimelineRespon3 : 0;
        const defaultTimelineCount = (_getAllTimelineRespon4 = getAllTimelineResponse === null || getAllTimelineResponse === void 0 ? void 0 : getAllTimelineResponse.defaultTimelineCount) !== null && _getAllTimelineRespon4 !== void 0 ? _getAllTimelineRespon4 : 0;
        const elasticTemplateTimelineCount = (_getAllTimelineRespon5 = getAllTimelineResponse === null || getAllTimelineResponse === void 0 ? void 0 : getAllTimelineResponse.elasticTemplateTimelineCount) !== null && _getAllTimelineRespon5 !== void 0 ? _getAllTimelineRespon5 : 0;
        const templateTimelineCount = (_getAllTimelineRespon6 = getAllTimelineResponse === null || getAllTimelineResponse === void 0 ? void 0 : getAllTimelineResponse.templateTimelineCount) !== null && _getAllTimelineRespon6 !== void 0 ? _getAllTimelineRespon6 : 0;
        const favoriteCount = (_getAllTimelineRespon7 = getAllTimelineResponse === null || getAllTimelineResponse === void 0 ? void 0 : getAllTimelineResponse.favoriteCount) !== null && _getAllTimelineRespon7 !== void 0 ? _getAllTimelineRespon7 : 0;
        if (!didCancel) {
          dispatch(_inputs.inputsActions.setQuery({
            inputId: _constants.InputsModelId.global,
            id: ALL_TIMELINE_QUERY_ID,
            loading: false,
            refetch: fetchData,
            inspect: null
          }));
          setAllTimelines({
            loading: false,
            totalCount,
            timelines: getAllTimeline(JSON.stringify(variables), timelines),
            customTemplateTimelineCount,
            defaultTimelineCount,
            elasticTemplateTimelineCount,
            templateTimelineCount,
            favoriteCount
          });
        }
      } catch (error) {
        if (!didCancel) {
          (0, _toasters.errorToToaster)({
            title: i18n.ERROR_FETCHING_TIMELINES_TITLE,
            error: error.body && error.body.message ? new Error(error.body.message) : error,
            dispatchToaster
          });
          setAllTimelines({
            loading: false,
            totalCount: 0,
            timelines: [],
            customTemplateTimelineCount: 0,
            defaultTimelineCount: 0,
            elasticTemplateTimelineCount: 0,
            templateTimelineCount: 0,
            favoriteCount: 0
          });
        }
      }
    };
    fetchData();
    return () => {
      didCancel = true;
      abortCtrl.abort();
    };
  }, [dispatch, dispatchToaster]);
  (0, _react.useEffect)(() => () => {
    dispatch(_inputs.inputsActions.deleteOneQuery({
      inputId: _constants.InputsModelId.global,
      id: ALL_TIMELINE_QUERY_ID
    }));
  }, [dispatch]);
  return {
    ...allTimelines,
    fetchAllTimeline
  };
};
exports.useGetAllTimeline = useGetAllTimeline;