"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.activeTimeline = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _timeline = require("../../../common/types/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Future Engineer
 * This class is just there to manage temporarily the reload of the active timeline when switching tabs
 * because of the bootstrap of the security solution app, we will always trigger the query
 * to avoid it we will cache its request and response so we can go back where the user was before switching tabs
 *
 * !!! Important !!! this is just there until, we will have a better way to bootstrap the app
 * I did not want to put in the store because I was feeling it will feel less temporarily and I did not want other engineer using it
 *
 */

class ActiveTimelineEvents {
  constructor() {
    (0, _defineProperty2.default)(this, "_activePage", 0);
    (0, _defineProperty2.default)(this, "_expandedDetail", {});
    (0, _defineProperty2.default)(this, "_pageName", '');
    (0, _defineProperty2.default)(this, "_request", null);
    (0, _defineProperty2.default)(this, "_response", null);
    (0, _defineProperty2.default)(this, "_eqlRequest", null);
    (0, _defineProperty2.default)(this, "_eqlResponse", null);
  }
  getActivePage() {
    return this._activePage;
  }
  setActivePage(activePage) {
    this._activePage = activePage;
  }
  getExpandedDetail() {
    return this._expandedDetail;
  }
  toggleExpandedDetail(expandedDetail) {
    const queryTab = _timeline.TimelineTabs.query;
    const currentExpandedDetail = this._expandedDetail[queryTab];
    let isSameExpandedDetail;

    // Check if the stored details matches the incoming detail
    if ((currentExpandedDetail === null || currentExpandedDetail === void 0 ? void 0 : currentExpandedDetail.panelView) === 'eventDetail') {
      var _expandedDetail$param, _currentExpandedDetai;
      isSameExpandedDetail = (expandedDetail === null || expandedDetail === void 0 ? void 0 : expandedDetail.panelView) === 'eventDetail' && (expandedDetail === null || expandedDetail === void 0 ? void 0 : (_expandedDetail$param = expandedDetail.params) === null || _expandedDetail$param === void 0 ? void 0 : _expandedDetail$param.eventId) === (currentExpandedDetail === null || currentExpandedDetail === void 0 ? void 0 : (_currentExpandedDetai = currentExpandedDetail.params) === null || _currentExpandedDetai === void 0 ? void 0 : _currentExpandedDetai.eventId);
    } else if ((currentExpandedDetail === null || currentExpandedDetail === void 0 ? void 0 : currentExpandedDetail.panelView) === 'hostDetail') {
      var _expandedDetail$param2, _currentExpandedDetai2;
      isSameExpandedDetail = (expandedDetail === null || expandedDetail === void 0 ? void 0 : expandedDetail.panelView) === 'hostDetail' && (expandedDetail === null || expandedDetail === void 0 ? void 0 : (_expandedDetail$param2 = expandedDetail.params) === null || _expandedDetail$param2 === void 0 ? void 0 : _expandedDetail$param2.hostName) === (currentExpandedDetail === null || currentExpandedDetail === void 0 ? void 0 : (_currentExpandedDetai2 = currentExpandedDetail.params) === null || _currentExpandedDetai2 === void 0 ? void 0 : _currentExpandedDetai2.hostName);
    } else if ((currentExpandedDetail === null || currentExpandedDetail === void 0 ? void 0 : currentExpandedDetail.panelView) === 'networkDetail') {
      var _expandedDetail$param3, _currentExpandedDetai3;
      isSameExpandedDetail = (expandedDetail === null || expandedDetail === void 0 ? void 0 : expandedDetail.panelView) === 'networkDetail' && (expandedDetail === null || expandedDetail === void 0 ? void 0 : (_expandedDetail$param3 = expandedDetail.params) === null || _expandedDetail$param3 === void 0 ? void 0 : _expandedDetail$param3.ip) === (currentExpandedDetail === null || currentExpandedDetail === void 0 ? void 0 : (_currentExpandedDetai3 = currentExpandedDetail.params) === null || _currentExpandedDetai3 === void 0 ? void 0 : _currentExpandedDetai3.ip);
    }

    // if so, unset it, otherwise set it
    if (isSameExpandedDetail) {
      this._expandedDetail = {};
    } else {
      this._expandedDetail = {
        [queryTab]: {
          ...expandedDetail
        }
      };
    }
  }
  setExpandedDetail(expandedDetail) {
    this._expandedDetail = expandedDetail;
  }
  getPageName() {
    return this._pageName;
  }
  setPageName(pageName) {
    this._pageName = pageName;
  }
  getRequest() {
    return this._request;
  }
  setRequest(req) {
    this._request = req;
  }
  getResponse() {
    return this._response;
  }
  setResponse(resp) {
    this._response = resp;
  }
  getEqlRequest() {
    return this._eqlRequest;
  }
  setEqlRequest(req) {
    this._eqlRequest = req;
  }
  getEqlResponse() {
    return this._eqlResponse;
  }
  setEqlResponse(resp) {
    this._eqlResponse = resp;
  }
}
const activeTimeline = exports.activeTimeline = new ActiveTimelineEvents();