"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TimelineDataTableComponent = exports.TimelineDataTable = exports.SAMPLE_SIZE_SETTING = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _selectors = require("../../../../store/selectors");
var _timeline = require("../../../../../../common/api/timeline");
var _helpers = require("../../../../../common/lib/cell_actions/helpers");
var _with_data_view = require("../../../../../common/components/with_data_view");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
var _kibana = require("../../../../../common/lib/kibana");
var _timeline2 = require("../../../../../../common/types/timeline");
var _model = require("../../../../../common/store/sourcerer/model");
var _sourcerer = require("../../../../../common/containers/sourcerer");
var _active_timeline_context = require("../../../../containers/active_timeline_context");
var _side_panel = require("../../../side_panel");
var _constants = require("../../../../../actions/constants");
var _formatted_field_udt = require("../../body/renderers/formatted_field_udt");
var _toolbar_additional_controls = _interopRequireDefault(require("./toolbar_additional_controls"));
var _styles = require("../styles");
var _store = require("../../../../store");
var _utils = require("../utils");
var _timeline_event_detail_row = require("./timeline_event_detail_row");
var _custom_timeline_data_grid_body = require("./custom_timeline_data_grid_body");
var _constants2 = require("../../body/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SAMPLE_SIZE_SETTING = exports.SAMPLE_SIZE_SETTING = 500;
const DataGridMemoized = /*#__PURE__*/_react.default.memo(_unifiedDataTable.UnifiedDataTable);
const TimelineDataTableComponent = exports.TimelineDataTableComponent = /*#__PURE__*/(0, _react.memo)(function TimelineDataTableMemo({
  columns,
  columnIds,
  dataView,
  activeTab,
  timelineId,
  itemsPerPage,
  itemsPerPageOptions,
  rowRenderers,
  sort,
  events,
  onFieldEdited,
  refetch,
  dataLoadingState,
  totalCount,
  onEventClosed,
  showExpandedDetails,
  expandedDetail,
  onChangePage,
  updatedAt,
  isTextBasedQuery = false,
  onSetColumns,
  onSort,
  onFilter
}) {
  const dispatch = (0, _reactRedux.useDispatch)();

  // Store context in state rather than creating object in provider value={} to prevent re-renders caused by a new object being created
  const [activeStatefulEventContext] = (0, _react.useState)({
    timelineID: timelineId,
    enableHostDetailsFlyout: true,
    enableIpDetailsFlyout: true,
    tabType: activeTab
  });
  const {
    services: {
      uiSettings,
      fieldFormats,
      storage,
      dataViewFieldEditor,
      notifications: {
        toasts: toastsService
      },
      theme,
      data: dataPluginContract
    }
  } = (0, _kibana.useKibana)();
  const [expandedDoc, setExpandedDoc] = (0, _react.useState)();
  const [fetchedPage, setFechedPage] = (0, _react.useState)(0);
  const {
    browserFields,
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const showTimeCol = (0, _react.useMemo)(() => !!dataView && !!dataView.timeFieldName, [dataView]);
  const {
    rowHeight,
    sampleSize,
    excludedRowRendererIds
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const tableRows = (0, _react.useMemo)(() => (0, _utils.transformTimelineItemToUnifiedRows)({
    events,
    dataView
  }), [events, dataView]);
  const handleOnEventDetailPanelOpened = (0, _react.useCallback)(eventData => {
    var _eventData$_index;
    const updatedExpandedDetail = {
      panelView: 'eventDetail',
      params: {
        eventId: eventData.id,
        indexName: (_eventData$_index = eventData._index) !== null && _eventData$_index !== void 0 ? _eventData$_index : '',
        // TODO: fix type error
        refetch
      }
    };
    dispatch(_store.timelineActions.toggleDetailPanel({
      ...updatedExpandedDetail,
      tabType: _timeline2.TimelineTabs.query,
      id: timelineId
    }));
    _active_timeline_context.activeTimeline.toggleExpandedDetail({
      ...updatedExpandedDetail
    });
  }, [dispatch, refetch, timelineId]);
  const handleOnPanelClosed = (0, _react.useCallback)(() => {
    var _expandedDetail$Timel;
    if ((_expandedDetail$Timel = expandedDetail[_timeline2.TimelineTabs.query]) !== null && _expandedDetail$Timel !== void 0 && _expandedDetail$Timel.panelView && timelineId === _timeline2.TimelineId.active && showExpandedDetails) {
      _active_timeline_context.activeTimeline.toggleExpandedDetail({});
    }
    setExpandedDoc(undefined);
    onEventClosed({
      tabType: _timeline2.TimelineTabs.query,
      id: timelineId
    });
  }, [onEventClosed, timelineId, expandedDetail, showExpandedDetails]);
  const onSetExpandedDoc = (0, _react.useCallback)(newDoc => {
    if (newDoc) {
      const timelineDoc = tableRows.find(r => r.id === newDoc.id);
      setExpandedDoc(timelineDoc);
      if (timelineDoc) {
        handleOnEventDetailPanelOpened(timelineDoc);
      }
    } else {
      handleOnPanelClosed();
    }
  }, [tableRows, handleOnEventDetailPanelOpened, handleOnPanelClosed]);
  const onColumnResize = (0, _react.useCallback)(({
    columnId,
    width
  }) => {
    dispatch(_store.timelineActions.updateColumnWidth({
      columnId,
      id: timelineId,
      width // initialWidth?
    }));
  }, [dispatch, timelineId]);
  const onResizeDataGrid = (0, _react.useCallback)(colSettings => {
    onColumnResize({
      columnId: colSettings.columnId,
      width: Math.round(colSettings.width)
    });
  }, [onColumnResize]);
  const onChangeItemsPerPage = (0, _react.useCallback)(itemsChangedPerPage => {
    dispatch(_store.timelineActions.updateItemsPerPage({
      id: timelineId,
      itemsPerPage: itemsChangedPerPage
    }));
  }, [dispatch, timelineId]);
  const customColumnRenderers = (0, _react.useMemo)(() => (0, _formatted_field_udt.getFormattedFields)({
    dataTableRows: tableRows,
    scopeId: 'timeline',
    headers: columns
  }), [columns, tableRows]);
  const handleFetchMoreRecords = (0, _react.useCallback)(() => {
    onChangePage(fetchedPage + 1);
    setFechedPage(fetchedPage + 1);
  }, [fetchedPage, onChangePage]);
  const additionalControls = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_toolbar_additional_controls.default, {
    timelineId: timelineId,
    updatedAt: updatedAt
  }), [timelineId, updatedAt]);
  const cellActionsMetadata = (0, _react.useMemo)(() => ({
    scopeId: timelineId
  }), [timelineId]);
  const onUpdateSampleSize = (0, _react.useCallback)(newSampleSize => {
    if (newSampleSize !== sampleSize) {
      dispatch(_store.timelineActions.updateSampleSize({
        id: timelineId,
        sampleSize: newSampleSize
      }));
      refetch();
    }
  }, [dispatch, sampleSize, timelineId, refetch]);
  const onUpdateRowHeight = (0, _react.useCallback)(newRowHeight => {
    if (newRowHeight !== rowHeight) {
      dispatch(_store.timelineActions.updateRowHeight({
        id: timelineId,
        rowHeight: newRowHeight
      }));
    }
  }, [dispatch, rowHeight, timelineId]);
  const dataGridServices = (0, _react.useMemo)(() => {
    return {
      theme,
      fieldFormats,
      storage,
      toastNotifications: toastsService,
      uiSettings,
      dataViewFieldEditor,
      data: dataPluginContract
    };
  }, [theme, fieldFormats, storage, toastsService, uiSettings, dataViewFieldEditor, dataPluginContract]);
  const enabledRowRenderers = (0, _react.useMemo)(() => {
    if (excludedRowRendererIds && excludedRowRendererIds.length === _timeline.RowRendererCount) return [];
    if (!excludedRowRendererIds) return rowRenderers;
    return rowRenderers.filter(rowRenderer => !excludedRowRendererIds.includes(rowRenderer.id));
  }, [excludedRowRendererIds, rowRenderers]);

  /**
   * Ref: https://eui.elastic.co/#/tabular-content/data-grid-advanced#custom-body-renderer
   */
  const trailingControlColumns = (0, _react.useMemo)(() => [{
    id: _constants2.TIMELINE_EVENT_DETAIL_ROW_ID,
    // The header cell should be visually hidden, but available to screen readers
    width: 0,
    headerCellRender: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    headerCellProps: {
      className: 'euiScreenReaderOnly'
    },
    // The footer cell can be hidden to both visual & SR users, as it does not contain meaningful information
    footerCellProps: {
      style: {
        display: 'none'
      }
    },
    // When rendering this custom cell, we'll want to override
    // the automatic width/heights calculated by EuiDataGrid
    rowCellRender: props => {
      const {
        rowIndex,
        ...restProps
      } = props;
      return /*#__PURE__*/_react.default.createElement(_timeline_event_detail_row.TimelineEventDetailRow, (0, _extends2.default)({
        event: tableRows[rowIndex],
        rowIndex: rowIndex,
        timelineId: timelineId,
        enabledRowRenderers: enabledRowRenderers
      }, restProps));
    }
  }], [enabledRowRenderers, tableRows, timelineId]);

  /**
   * Ref: https://eui.elastic.co/#/tabular-content/data-grid-advanced#custom-body-renderer
   */
  const renderCustomBodyCallback = (0, _react.useCallback)(({
    Cell,
    visibleRowData,
    visibleColumns,
    setCustomGridBodyProps
  }) => /*#__PURE__*/_react.default.createElement(_custom_timeline_data_grid_body.CustomTimelineDataGridBody, {
    rows: tableRows,
    Cell: Cell,
    visibleColumns: visibleColumns,
    visibleRowData: visibleRowData,
    setCustomGridBodyProps: setCustomGridBodyProps,
    enabledRowRenderers: enabledRowRenderers
  }), [tableRows, enabledRowRenderers]);
  return /*#__PURE__*/_react.default.createElement(_stateful_event_context.StatefulEventContext.Provider, {
    value: activeStatefulEventContext
  }, /*#__PURE__*/_react.default.createElement(_styles.StyledTimelineUnifiedDataTable, null, (dataLoadingState === _unifiedDataTable.DataLoadingState.loading || dataLoadingState === _unifiedDataTable.DataLoadingState.loadingMore) && /*#__PURE__*/_react.default.createElement(_styles.StyledEuiProgress, {
    "data-test-subj": "discoverDataGridUpdating",
    size: "xs",
    color: "accent"
  }), /*#__PURE__*/_react.default.createElement(DataGridMemoized, {
    ariaLabelledBy: "timelineDocumentsAriaLabel",
    className: 'udtTimeline',
    columns: columnIds,
    expandedDoc: expandedDoc,
    dataView: dataView,
    showColumnTokens: true,
    loadingState: dataLoadingState,
    onFilter: onFilter,
    onResize: onResizeDataGrid,
    onSetColumns: onSetColumns,
    onSort: !isTextBasedQuery ? onSort : undefined,
    rows: tableRows,
    sampleSizeState: sampleSize || 500,
    onUpdateSampleSize: onUpdateSampleSize,
    setExpandedDoc: onSetExpandedDoc,
    showTimeCol: showTimeCol,
    isSortEnabled: true,
    sort: sort,
    rowHeightState: rowHeight,
    isPlainRecord: isTextBasedQuery,
    rowsPerPageState: itemsPerPage,
    onUpdateRowsPerPage: onChangeItemsPerPage,
    onUpdateRowHeight: onUpdateRowHeight,
    onFieldEdited: onFieldEdited,
    cellActionsTriggerId: _constants.SecurityCellActionsTrigger.DEFAULT,
    services: dataGridServices,
    visibleCellActions: 3,
    externalCustomRenderers: customColumnRenderers,
    renderDocumentView: _helpers.EmptyComponent,
    rowsPerPageOptions: itemsPerPageOptions,
    showFullScreenButton: false,
    useNewFieldsApi: true,
    maxDocFieldsDisplayed: 50,
    consumer: "timeline",
    totalHits: totalCount,
    onFetchMoreRecords: handleFetchMoreRecords,
    configRowHeight: 3,
    showMultiFields: true,
    cellActionsMetadata: cellActionsMetadata,
    externalAdditionalControls: additionalControls,
    trailingControlColumns: trailingControlColumns,
    renderCustomGridBody: renderCustomBodyCallback
  }), showExpandedDetails && /*#__PURE__*/_react.default.createElement(_side_panel.DetailsPanel, {
    browserFields: browserFields,
    handleOnPanelClosed: handleOnPanelClosed,
    runtimeMappings: runtimeMappings,
    tabType: activeTab,
    scopeId: timelineId,
    isFlyoutView: true
  })));
});
const TimelineDataTable = exports.default = exports.TimelineDataTable = (0, _with_data_view.withDataView)(TimelineDataTableComponent);

// eslint-disable-next-line import/no-default-export