"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomTimelineDataGridBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../body/constants");
var _use_stateful_row_renderer = require("../../body/events/stateful_row_renderer/use_stateful_row_renderer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *
 * In order to render the additional row with every event ( which displays the row-renderer, notes and notes editor)
 * we need to pass a way for EuiDataGrid to render the whole grid body via a custom component
 *
 * This component is responsible for styling and accessibility of the custom designed cells.
 *
 * In our case, we need TimelineExpandedRow ( technicall a data grid column which spans the whole width of the data grid)
 * component to be shown as an addendum to the normal event row. As mentioned above, it displays the row-renderer, notes and notes editor
 *
 * Ref: https://eui.elastic.co/#/tabular-content/data-grid-advanced#custom-body-renderer
 *
 * */
const CustomTimelineDataGridBody = exports.CustomTimelineDataGridBody = /*#__PURE__*/(0, _react.memo)(function CustomTimelineDataGridBody(props) {
  const {
    Cell,
    visibleColumns,
    visibleRowData,
    rows,
    enabledRowRenderers
  } = props;
  const visibleRows = (0, _react.useMemo)(() => (rows !== null && rows !== void 0 ? rows : []).slice(visibleRowData.startRow, visibleRowData.endRow), [rows, visibleRowData]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visibleRows.map((row, rowIndex) => /*#__PURE__*/_react.default.createElement(CustomDataGridSingleRow, {
    rowData: row,
    rowIndex: rowIndex,
    key: rowIndex,
    visibleColumns: visibleColumns,
    Cell: Cell,
    enabledRowRenderers: enabledRowRenderers
  })));
});

/**
 *
 * A Simple Wrapper component for displaying a custom grid row
 *
 */
const CustomGridRow = _styledComponents.default.div.attrs(props => {
  var _props$className;
  return {
    className: `euiDataGridRow ${(_props$className = props.className) !== null && _props$className !== void 0 ? _props$className : ''}`,
    role: 'row'
  };
})`
  width: fit-content;
  border-bottom: 1px solid ${props => props.theme.eui.euiBorderThin};
`;

/**
 *
 * A Simple Wrapper component for displaying a custom data grid `cell`
 */
const CustomGridRowCellWrapper = _styledComponents.default.div.attrs({
  className: 'rowCellWrapper',
  role: 'row'
})`
  display: flex;
`;
/**
 *
 * RenderCustomBody component above uses this component to display a single row.
 *
 * */
const CustomDataGridSingleRow = /*#__PURE__*/(0, _react.memo)(function CustomDataGridSingleRow(props) {
  const {
    rowIndex,
    rowData,
    enabledRowRenderers,
    visibleColumns,
    Cell
  } = props;
  const {
    canShowRowRenderer
  } = (0, _use_stateful_row_renderer.useStatefulRowRenderer)({
    data: rowData.ecs,
    rowRenderers: enabledRowRenderers
  });

  /**
   * removes the border between the actual row ( timelineEvent) and `TimelineEventDetail` row
   * which renders the row-renderer, notes and notes editor
   *
   */
  const cellCustomStyle = (0, _react.useMemo)(() => canShowRowRenderer ? {
    borderBottom: 'none'
  } : {}, [canShowRowRenderer]);
  return /*#__PURE__*/_react.default.createElement(CustomGridRow, {
    className: `${rowIndex % 2 === 0 ? 'euiDataGridRow--striped' : ''}`,
    key: rowIndex
  }, /*#__PURE__*/_react.default.createElement(CustomGridRowCellWrapper, null, visibleColumns.map((column, colIndex) => {
    // Skip the expanded row cell - we'll render it manually outside of the flex wrapper
    if (column.id !== _constants.TIMELINE_EVENT_DETAIL_ROW_ID) {
      return /*#__PURE__*/_react.default.createElement(Cell, {
        style: cellCustomStyle,
        colIndex: colIndex,
        visibleRowIndex: rowIndex,
        key: `${rowIndex},${colIndex}`
      });
    }
    return null;
  })), canShowRowRenderer ? /*#__PURE__*/_react.default.createElement(Cell, {
    colIndex: visibleColumns.length - 1 // If the row is being shown, it should always be the last index
    ,
    visibleRowIndex: rowIndex
  }) : null);
});