"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMELINE_TEMPLATE = exports.SEARCH_BOX_TIMELINE_PLACEHOLDER = exports.PARTICIPANTS = exports.EVENTS_TABLE_ARIA_LABEL = exports.DEFAULT_TIMELINE_TITLE = exports.DEFAULT_TIMELINE_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
var _timeline = require("../../../../common/api/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TIMELINE_TITLE = exports.DEFAULT_TIMELINE_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.defaultTimelineTitle', {
  defaultMessage: 'None'
});
const DEFAULT_TIMELINE_DESCRIPTION = exports.DEFAULT_TIMELINE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.defaultTimelineDescription', {
  defaultMessage: 'Timeline offered by default when creating new timeline.'
});
const EVENTS_TABLE_ARIA_LABEL = ({
  activePage,
  totalPages
}) => _i18n.i18n.translate('xpack.securitySolution.timeline.eventsTableAriaLabel', {
  values: {
    activePage,
    totalPages
  },
  defaultMessage: 'events; Page {activePage} of {totalPages}'
});
exports.EVENTS_TABLE_ARIA_LABEL = EVENTS_TABLE_ARIA_LABEL;
const SEARCH_BOX_TIMELINE_PLACEHOLDER = timelineType => _i18n.i18n.translate('xpack.securitySolution.timeline.searchBoxPlaceholder', {
  values: {
    timeline: timelineType === _timeline.TimelineType.template ? 'Timeline template' : 'Timeline'
  },
  defaultMessage: 'e.g. {timeline} name or description'
});
exports.SEARCH_BOX_TIMELINE_PLACEHOLDER = SEARCH_BOX_TIMELINE_PLACEHOLDER;
const TIMELINE_TEMPLATE = exports.TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.flyoutTimelineTemplateLabel', {
  defaultMessage: 'Timeline template'
});
const PARTICIPANTS = exports.PARTICIPANTS = _i18n.i18n.translate('xpack.securitySolution.timeline.participantsTitle', {
  defaultMessage: 'Participants'
});