"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tourConfig = exports.timelineTourSteps = exports.TIMELINE_TOUR_CONFIG_ANCHORS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _timeline = require("../../../../../common/api/timeline");
var _types = require("../../../../../common/types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMELINE_TOUR_CONFIG_ANCHORS = exports.TIMELINE_TOUR_CONFIG_ANCHORS = {
  ACTION_MENU: 'timeline-action-menu',
  DATA_VIEW: 'timeline-data-view',
  DATA_PROVIDER: 'toggle-data-provider',
  SAVE_TIMELINE: 'save-timeline-action',
  ADD_TO_FAVORITES: 'add-to-favorites'
};
const timelineTourSteps = exports.timelineTourSteps = [{
  title: i18n.TIMELINE_TOUR_TIMELINE_ACTIONS_STEP_TITLE,
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.timeline.tour.newTimeline.description",
    defaultMessage: "Click {newButton} to create a new Timeline. Click {openButton} to open an existing one.",
    values: {
      newButton: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, i18n.TIMELINE_TOUR_NEW),
      openButton: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, i18n.TIMELINE_TOUR_OPEN)
    }
  })),
  anchor: TIMELINE_TOUR_CONFIG_ANCHORS.ACTION_MENU
}, {
  title: i18n.TIMELINE_TOUR_ADD_TO_FAVORITES_STEP_TITLE,
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.timeline.tour.addToFavorites.description",
    defaultMessage: "Click to favorite your Timeline so you can quickly find it later."
  })),
  anchor: TIMELINE_TOUR_CONFIG_ANCHORS.ADD_TO_FAVORITES
}, {
  timelineTab: _types.TimelineTabs.query,
  title: i18n.TIMELINE_TOUR_CHANGE_DATA_VIEW_TITLE,
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.timeline.tour.changeDataView.description",
    defaultMessage: "Click the {dataViewButton} menu to choose the event or alert data that you want to display.",
    values: {
      dataViewButton: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, " ", i18n.TIMELINE_TOUR_DATA_VIEW)
    }
  })),
  anchor: TIMELINE_TOUR_CONFIG_ANCHORS.DATA_VIEW
}, {
  timelineType: _timeline.TimelineType.default,
  timelineTab: _types.TimelineTabs.query,
  title: i18n.TIMELINE_TOUR_DATA_PROVIDER_VISIBILITY_TITLE,
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.TIMELINE_TOUR_DATA_PROVIDER_VISIBILITY_DESCRIPTION),
  anchor: TIMELINE_TOUR_CONFIG_ANCHORS.DATA_PROVIDER
}, {
  title: i18n.TIMELINE_TOUR_SAVE_TIMELINE_STEP_TITLE,
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.timeline.tour.saveTimeline.description",
    defaultMessage: "Click {saveButton} to manually save new changes. While saving your Timeline, you can {editButton} its name and description or save it as a new Timeline.",
    values: {
      saveButton: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, i18n.TIMELINE_TOUR_SAVE),
      editButton: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, i18n.TIMELINE_TOUR_EDIT)
    }
  })),
  anchor: TIMELINE_TOUR_CONFIG_ANCHORS.SAVE_TIMELINE
}];
const tourConfig = exports.tourConfig = {
  currentTourStep: 1,
  isTourActive: true,
  tourPopoverWidth: 300,
  tourSubtitle: i18n.TIMELINE_TOUR_SUBTITLE
};