"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineTour = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_is_element_mounted = require("../../../../detection_engine/rule_management_ui/components/rules_table/rules_table/guided_onboarding/use_is_element_mounted");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _step_config = require("./step_config");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * This timeline tour only valid for 8.12 release is not needed for 8.13
 *
 * */

const TimelineTourComp = props => {
  var _updatedTourSteps;
  const {
    activeTab,
    switchToTab,
    timelineType
  } = props;
  const {
    services: {
      storage
    }
  } = (0, _kibana.useKibana)();
  const updatedTourSteps = (0, _react.useMemo)(() => _step_config.timelineTourSteps.filter(step => !step.timelineType || step.timelineType === timelineType), [timelineType]);
  const [tourState, setTourState] = (0, _react.useState)(() => {
    const restoredTourState = storage.get(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.TIMELINE);
    if (restoredTourState != null) {
      return restoredTourState;
    }
    return _step_config.tourConfig;
  });
  const finishTour = (0, _react.useCallback)(() => {
    setTourState(prev => {
      return {
        ...prev,
        isTourActive: false
      };
    });
  }, []);
  const nextStep = (0, _react.useCallback)(() => {
    setTourState(prev => {
      return {
        ...prev,
        currentTourStep: prev.currentTourStep + 1
      };
    });
  }, []);
  (0, _react.useEffect)(() => {
    storage.set(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.TIMELINE, tourState);
  }, [tourState, storage]);
  const getFooterAction = (0, _react.useCallback)(step => {
    // if it's the last step, we don't want to show the next button
    return step === updatedTourSteps.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "success",
      size: "s",
      onClick: finishTour
    }, i18n.TIMELINE_TOUR_FINISH) : [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      onClick: finishTour
    }, i18n.TIMELINE_TOUR_EXIT), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "success",
      size: "s",
      onClick: nextStep
    }, i18n.TIMELINE_TOUR_NEXT)];
  }, [finishTour, nextStep, updatedTourSteps.length]);
  const nextEl = (_updatedTourSteps = updatedTourSteps[tourState.currentTourStep - 1]) === null || _updatedTourSteps === void 0 ? void 0 : _updatedTourSteps.anchor;
  const isElementAtCurrentStepMounted = (0, _use_is_element_mounted.useIsElementMounted)(nextEl);
  const currentStepConfig = updatedTourSteps[tourState.currentTourStep - 1];
  if (currentStepConfig !== null && currentStepConfig !== void 0 && currentStepConfig.timelineTab && currentStepConfig.timelineTab !== activeTab) {
    switchToTab(currentStepConfig.timelineTab);
  }
  if (!tourState.isTourActive || !isElementAtCurrentStepMounted) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, updatedTourSteps.map((steps, idx) => {
    const stepCount = idx + 1;
    if (tourState.currentTourStep !== stepCount) return null;
    const panelProps = {
      'data-test-subj': `timeline-tour-step-${idx + 1}`
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
      panelProps: panelProps,
      key: idx,
      step: stepCount,
      isStepOpen: tourState.isTourActive && tourState.currentTourStep === idx + 1,
      minWidth: tourState.tourPopoverWidth,
      stepsTotal: updatedTourSteps.length,
      onFinish: finishTour,
      title: steps.title,
      content: steps.content,
      anchor: `#${steps.anchor}`,
      subtitle: _step_config.tourConfig.tourSubtitle,
      footerAction: getFooterAction(stepCount)
    });
  }));
};
const TimelineTour = exports.TimelineTour = /*#__PURE__*/_react.default.memo(TimelineTourComp);