"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_session_view = require("./use_session_view");
var _layout = require("../shared/layout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaxWidthFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 100%;
`;
const SessionViewWrapper = _styledComponents.default.div`
  ${({
  theme
}) => `margin: 0 ${theme.eui.euiSizeM};`}
`;
const MaxWidthPageFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  max-width: 100%;
  box-sizing: border-box;
`;
const StyledFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  ${({
  theme
}) => `margin: 0 ${theme.eui.euiSizeM};`}
  height: 100%;
  min-width: 320px;
`;
const SessionTabContent = ({
  timelineId
}) => {
  const [height, setHeight] = (0, _react.useState)(0);
  const measuredRef = (0, _react.useCallback)(node => {
    if (node !== null) {
      setHeight(node.getBoundingClientRect().height);
    }
  }, []);
  const {
    Navigation
  } = (0, _use_session_view.useSessionViewNavigation)({
    scopeId: timelineId
  });
  const {
    SessionView,
    shouldShowDetailsPanel,
    DetailsPanel
  } = (0, _use_session_view.useSessionView)({
    scopeId: timelineId,
    height
  });
  return /*#__PURE__*/_react.default.createElement(MaxWidthPageFlexGroup, {
    alignItems: "flexStart",
    gutterSize: "none",
    ref: measuredRef,
    "data-test-subj": "timeline-session-content"
  }, /*#__PURE__*/_react.default.createElement(MaxWidthFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), Navigation, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(SessionViewWrapper, null, SessionView)), shouldShowDetailsPanel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_layout.VerticalRule, null), /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    grow: 1
  }, DetailsPanel)));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = SessionTabContent;
module.exports = exports.default;